/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.PartitionWhiteSpace;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;

public final class GsonPartitionWhiteSpaceImpl
implements GsonBase,
PartitionWhiteSpace {
    private final List<String> characterList;
    private final boolean javawhiteSpace;

    public GsonPartitionWhiteSpaceImpl(JsonObject jsonObject) {
        this.characterList = jsonObject.has("characterList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("characterList").spliterator(), false).map(e -> e.getAsString()).collect(Collectors.toList())) : Collections.emptyList();
        this.javawhiteSpace = jsonObject.has("javawhiteSpace") ? jsonObject.get("javawhiteSpace").getAsBoolean() : false;
    }

    public GsonPartitionWhiteSpaceImpl(List<String> characterList, boolean javawhiteSpace) {
        this.characterList = characterList;
        this.javawhiteSpace = javawhiteSpace;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "PartitionWhiteSpace");
        o.add("characterList", (JsonElement)GsonBase.toJsonArray(this.getCharacterList().stream().map(JsonPrimitive::new).collect(Collectors.toList())));
        o.addProperty("javawhiteSpace", Boolean.valueOf(this.isJavawhiteSpace()));
        return o;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + " { " + "characterList : " + this.characterList + ", " + "javawhiteSpace : " + this.javawhiteSpace + " }";
    }

    @Override
    public List<String> getCharacterList() {
        return this.characterList;
    }

    @Override
    public boolean isJavawhiteSpace() {
        return this.javawhiteSpace;
    }

    public static class Builder
    implements PartitionWhiteSpace.Builder {
        private final EditorGModel instance;
        private final List<String> characterList = new ArrayList<String>();
        private boolean javawhiteSpace;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder characterList(List<String> characterList) {
            this.characterList.addAll(characterList);
            return this;
        }

        @Override
        public Builder appendCharacterList(String characterList) {
            this.characterList.add(characterList);
            return this;
        }

        @Override
        public Builder javawhiteSpace(boolean javawhiteSpace) {
            this.javawhiteSpace = javawhiteSpace;
            return this;
        }

        @Override
        public PartitionWhiteSpace build() {
            return new GsonPartitionWhiteSpaceImpl(this.characterList, this.javawhiteSpace);
        }
    }
}

