/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;

public class ConcatStringBinding<T>
extends StringBinding {
    private final String delimiter;
    private final ObservableValue<T>[] sources;

    @SafeVarargs
    public ConcatStringBinding(String delimiter, ObservableValue<T> ... sources) {
        this.delimiter = delimiter;
        this.sources = sources;
        this.bind((Observable[])sources);
    }

    protected String computeValue() {
        return Stream.of(this.sources).map(s -> s.getValue()).map(v -> v == null ? "" : v.toString()).filter(v -> !v.isEmpty()).collect(Collectors.joining(this.delimiter));
    }
}

