/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConvolveMatrixEdgeMode implements Enumerator
{
    DUPLICATE(0, "duplicate", "duplicate"),
    WRAP(1, "wrap", "wrap"),
    NONE(2, "none", "none");

    public static final int DUPLICATE_VALUE = 0;
    public static final int WRAP_VALUE = 1;
    public static final int NONE_VALUE = 2;
    private static final ConvolveMatrixEdgeMode[] VALUES_ARRAY;
    public static final List<ConvolveMatrixEdgeMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConvolveMatrixEdgeMode[]{DUPLICATE, WRAP, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConvolveMatrixEdgeMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConvolveMatrixEdgeMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConvolveMatrixEdgeMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConvolveMatrixEdgeMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConvolveMatrixEdgeMode get(int value) {
        switch (value) {
            case 0: {
                return DUPLICATE;
            }
            case 1: {
                return WRAP;
            }
            case 2: {
                return NONE;
            }
        }
        return null;
    }

    private ConvolveMatrixEdgeMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

