/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.mobile.animations;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;
import org.eclipse.fx.ui.mobile.Card;

public abstract class TransitionDelegate {
    public void transitionTo(final BorderPane parent, final Card from, final Card to) {
        parent.setCenter(null);
        Bounds b = from.getBoundsInParent();
        to.resizeRelocate(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        parent.getChildren().add(0, (Object)to);
        parent.getChildren().add(1, (Object)from);
        Animation animation = this.createAndPrepareAnimation(from, to);
        animation.onFinishedProperty().set((Object)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.getChildren().remove((Object)from);
                parent.getChildren().remove((Object)to);
                parent.setCenter((Node)to);
                TransitionDelegate.this.resetProperties(from, to);
            }
        });
        animation.play();
    }

    protected abstract Animation createAndPrepareAnimation(Card var1, Card var2);

    protected abstract void resetProperties(Card var1, Card var2);

    public static TransitionDelegate slideLeft() {
        return new TransitionDelegate(){

            @Override
            protected void resetProperties(Card from, Card to) {
                to.setTranslateX(0.0);
                from.setTranslateX(0.0);
            }

            @Override
            protected Animation createAndPrepareAnimation(Card from, Card to) {
                from.setOpacity(1.0);
                double deltaX = -from.getBoundsInLocal().getWidth();
                to.setTranslateX(-deltaX);
                return new ParallelTransition(new Animation[]{this.createTransition(deltaX, from), this.createTransition(deltaX, to)});
            }

            private TranslateTransition createTransition(double deltaX, Card node) {
                TranslateTransition t = new TranslateTransition(new Duration(1000.0));
                t.setInterpolator(Interpolator.EASE_BOTH);
                t.setByX(deltaX);
                t.setNode((Node)node);
                return t;
            }
        };
    }

    public static TransitionDelegate slideRight() {
        return new TransitionDelegate(){

            @Override
            protected void resetProperties(Card from, Card to) {
                to.setTranslateX(0.0);
                from.setTranslateX(0.0);
            }

            @Override
            protected Animation createAndPrepareAnimation(Card from, Card to) {
                from.setOpacity(1.0);
                double deltaX = from.getBoundsInLocal().getWidth();
                to.setTranslateX(-deltaX);
                return new ParallelTransition(new Animation[]{this.createTransition(deltaX, from), this.createTransition(deltaX, to)});
            }

            private TranslateTransition createTransition(double deltaX, Card node) {
                TranslateTransition t = new TranslateTransition(new Duration(1000.0));
                t.setInterpolator(Interpolator.EASE_BOTH);
                t.setByX(deltaX);
                t.setNode((Node)node);
                return t;
            }
        };
    }

    public static TransitionDelegate fade() {
        return new TransitionDelegate(){

            @Override
            protected void resetProperties(Card from, Card to) {
                from.setOpacity(1.0);
                to.setOpacity(1.0);
            }

            @Override
            protected Animation createAndPrepareAnimation(Card from, Card to) {
                FadeTransition t = new FadeTransition(Duration.seconds((double)1.0));
                t.setNode((Node)from);
                t.setInterpolator(Interpolator.EASE_BOTH);
                t.setFromValue(1.0);
                t.setToValue(0.0);
                return t;
            }
        };
    }

    public static TransitionDelegate zoomSlide() {
        return new TransitionDelegate(){

            @Override
            protected void resetProperties(Card from, Card to) {
                to.setTranslateX(0.0);
                to.setScaleX(1.0);
                to.setScaleY(1.0);
                from.setTranslateX(0.0);
                from.setScaleX(1.0);
                from.setScaleY(1.0);
                to.setEffect(null);
                from.setEffect(null);
            }

            @Override
            protected Animation createAndPrepareAnimation(Card from, Card to) {
                double deltaX = -from.getBoundsInLocal().getWidth();
                to.setTranslateX(-deltaX);
                TranslateTransition slideFrom = this.translateTransition((Node)from, deltaX);
                TranslateTransition slideTo = this.translateTransition((Node)to, deltaX);
                ScaleTransition zoomOutFrom = this.scaleTransition((Node)from, 0.7);
                ScaleTransition zoomOutTo = this.scaleTransition((Node)from, 0.7);
                ScaleTransition zoomInFrom = this.scaleTransition((Node)from, 1.0);
                ScaleTransition zoomInTo = this.scaleTransition((Node)from, 1.0);
                return new SequentialTransition(new Animation[]{new ParallelTransition(new Animation[]{zoomOutFrom, zoomOutTo}), new ParallelTransition(new Animation[]{slideFrom, slideTo}), new ParallelTransition(new Animation[]{zoomInFrom, zoomInTo})});
            }

            private TranslateTransition translateTransition(Node node, double deltaX) {
                TranslateTransition t = new TranslateTransition(Duration.millis((double)300.0));
                t.setNode(node);
                t.setInterpolator(Interpolator.EASE_BOTH);
                t.setByX(deltaX);
                return t;
            }

            private ScaleTransition scaleTransition(Node node, double to) {
                ScaleTransition t = new ScaleTransition(Duration.millis((double)300.0));
                t.setNode(node);
                t.setToX(to);
                t.setToY(to);
                t.setInterpolator(Interpolator.EASE_BOTH);
                return t;
            }
        };
    }
}

