/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.quickfix;

import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class FXGraphQuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    IJavaProjectProvider provider;

    @Fix(value="FXGraphJavaValidator.UNKNOWN_CONTROLLER_FIELD")
    public void fixAddControllerField(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add controller field", "Add a field of '" + issue.getData()[0] + "' to the controller '" + issue.getData()[1] + "'", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IJavaProject p = (IJavaProject)context.getXtextDocument().readOnly((IUnitOfWork)new IUnitOfWork<IJavaProject, XtextResource>(){

                    public IJavaProject exec(XtextResource state) throws Exception {
                        return (this).FXGraphQuickfixProvider.this.provider.getJavaProject(state.getResourceSet());
                    }
                });
                IType type = p.findType(issue.getData()[1]);
                String[][] resolvedType = type.resolveType("FXML");
                if (resolvedType == null) {
                    type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((resolvedType = type.resolveType(Signature.getSimpleName((String)issue.getData()[2]))) == null) {
                    type.getCompilationUnit().createImport(issue.getData()[2], null, (IProgressMonitor)new NullProgressMonitor());
                }
                type.createField("@FXML " + Signature.getSimpleName((String)issue.getData()[2]) + " " + issue.getData()[0] + ";", null, true, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        acceptor.accept(issue, "Remove id field", "Remove the id field from the element", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument xtextDocument = context.getXtextDocument();
                StringBuilder b = new StringBuilder();
                int start = issue.getOffset();
                while (!b.toString().startsWith("id")) {
                    b.insert(0, xtextDocument.getChar(--start));
                }
                xtextDocument.replace(start, (b + issue.getData()[0]).length(), "");
            }
        });
    }

    @Fix(value="FXGraphJavaValidator.UNKNOWN_CONTROLLER_METHOD")
    public void fixAddControllerMethod(Issue issue, IssueResolutionAcceptor acceptor) {
        final String methodName = issue.getData()[0];
        final String controllerClass = issue.getData()[1];
        final String argType = issue.getData()[2];
        final String simpleArgType = Signature.getSimpleName((String)argType);
        acceptor.accept(issue, "Add controller method " + methodName + "(" + simpleArgType + ")", "Add a controller method '" + methodName + "(" + simpleArgType + ")' to controller '" + controllerClass + "'", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IJavaProject p = (IJavaProject)context.getXtextDocument().readOnly((IUnitOfWork)new IUnitOfWork<IJavaProject, XtextResource>(){

                    public IJavaProject exec(XtextResource state) throws Exception {
                        return (this).FXGraphQuickfixProvider.this.provider.getJavaProject(state.getResourceSet());
                    }
                });
                IType type = p.findType(controllerClass);
                String[][] resolvedType = type.resolveType("FXML");
                if (resolvedType == null) {
                    type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((resolvedType = type.resolveType(simpleArgType)) == null) {
                    type.getCompilationUnit().createImport(argType, null, (IProgressMonitor)new NullProgressMonitor());
                }
                type.createMethod("@FXML public void " + methodName + "(" + simpleArgType + " event) {}", null, true, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        acceptor.accept(issue, "Add controller method " + methodName + "()", "Add a controller method '" + methodName + "()' to controller '" + controllerClass + "'", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IJavaProject p = (IJavaProject)context.getXtextDocument().readOnly((IUnitOfWork)new IUnitOfWork<IJavaProject, XtextResource>(){

                    public IJavaProject exec(XtextResource state) throws Exception {
                        return (this).FXGraphQuickfixProvider.this.provider.getJavaProject(state.getResourceSet());
                    }
                });
                IType type = p.findType(controllerClass);
                String[][] resolvedType = type.resolveType("FXML");
                if (resolvedType == null) {
                    type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                }
                type.createMethod("@FXML public void " + methodName + "() {}", null, true, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }
}

