/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.fx.ide.jdt.core.JavaFXCore;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTasksFactory;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.parameters.ParametersFactory;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.NewJavaFXProjectWizardPageThree;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.NewJavaFXProjectWizardPageTwo;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.templates.FXProjectCtrlClassTemplate;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.templates.FXProjectFXGraphTemplate;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.templates.FXProjectFXMLTemplate;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.templates.FXProjectMainClassTemplate;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.templates.FXProjectMainMobileClassTemplate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavaFXProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewJavaProjectWizardPageOne fFirstPage;
    private NewJavaFXProjectWizardPageTwo fSecondPage;
    private NewJavaFXProjectWizardPageThree fThirdPage;
    private IConfigurationElement fConfigElement;
    private ProjectData projectData;

    public JavaFXProjectWizard() {
        this(null, null, null);
    }

    public JavaFXProjectWizard(NewJavaProjectWizardPageOne pageOne, NewJavaFXProjectWizardPageTwo pageTwo, NewJavaFXProjectWizardPageThree pageThree) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
        this.fFirstPage = pageOne;
        this.fSecondPage = pageTwo;
        this.fThirdPage = pageThree;
        this.projectData = new ProjectData();
    }

    public void addPages() {
        if (this.fFirstPage == null) {
            this.fFirstPage = new NewJavaProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.fFirstPage);
        if (this.fSecondPage == null) {
            this.fSecondPage = new NewJavaFXProjectWizardPageTwo(this.fFirstPage);
        }
        this.addPage((IWizardPage)this.fSecondPage);
        if (this.fThirdPage == null) {
            this.fThirdPage = new NewJavaFXProjectWizardPageThree(this.projectData);
        }
        this.addPage((IWizardPage)this.fThirdPage);
        this.fFirstPage.init(this.getSelection(), this.getActivePart());
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            IJavaProject p;
            final IJavaElement newElement = this.getCreatedElement();
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            try {
                p = (IJavaProject)newElement;
                IClasspathEntry[] current = p.getRawClasspath();
                int i = current.length + 1;
                if (this.projectData.mainApp.equals("Mobile")) {
                    ++i;
                }
                IClasspathEntry[] currentFX = new IClasspathEntry[i];
                System.arraycopy(current, 0, currentFX, 0, current.length);
                currentFX[current.length] = JavaCore.newContainerEntry((IPath)JavaFXCore.JAVAFX_CONTAINER_PATH);
                if (this.projectData.mainApp.equals("Mobile")) {
                    currentFX[current.length + 1] = JavaCore.newContainerEntry((IPath)JavaFXCore.MOBILE_CONTAINER_PATH);
                }
                p.setRawClasspath(currentFX, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            if (this.projectData.mainApp.equals("Desktop")) {
                IFile buildFile = this.fSecondPage.getJavaProject().getProject().getFile((IPath)new Path("build.fxbuild"));
                AntTask task = AntTasksFactory.eINSTANCE.createAntTask();
                task.setBuildDirectory("${project}/build");
                task.setDeploy(AntTasksFactory.eINSTANCE.createDeploy());
                task.getDeploy().setApplication(ParametersFactory.eINSTANCE.createApplication());
                task.getDeploy().getApplication().setName(this.fFirstPage.getProjectName());
                task.getDeploy().setInfo(ParametersFactory.eINSTANCE.createInfo());
                task.setSignjar(AntTasksFactory.eINSTANCE.createSignJar());
                XMIResourceImpl resource = new XMIResourceImpl();
                resource.getContents().add((Object)task);
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation((XMIResource)resource, buildFile){
                    private final /* synthetic */ XMIResource val$resource;
                    private final /* synthetic */ IFile val$buildFile;
                    {
                        this.val$resource = xMIResource;
                        this.val$buildFile = iFile;
                    }

                    public void execute(IProgressMonitor monitor) {
                        block21: {
                            if (!this.val$resource.getContents().isEmpty()) {
                                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                                options.put("USE_XMI_TYPE", Boolean.TRUE);
                                ByteArrayOutputStream streamOut = null;
                                ByteArrayInputStream streamIn = null;
                                try {
                                    try {
                                        streamOut = new ByteArrayOutputStream();
                                        this.val$resource.save((OutputStream)streamOut, options);
                                        streamIn = new ByteArrayInputStream(streamOut.toByteArray());
                                        this.val$buildFile.create((InputStream)streamIn, true, monitor);
                                    }
                                    catch (IOException | CoreException e) {
                                        e.printStackTrace();
                                        options.clear();
                                        if (streamOut != null) {
                                            try {
                                                streamOut.close();
                                            }
                                            catch (IOException e2) {
                                                e2.printStackTrace();
                                            }
                                        }
                                        if (streamIn == null) break block21;
                                        try {
                                            streamIn.close();
                                        }
                                        catch (IOException e3) {
                                            e3.printStackTrace();
                                        }
                                    }
                                }
                                finally {
                                    options.clear();
                                    if (streamOut != null) {
                                        try {
                                            streamOut.close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (streamIn != null) {
                                        try {
                                            streamIn.close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)operation);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                IFile mainClass;
                p = this.fSecondPage.getJavaProject();
                IPackageFragment f = p.getPackageFragments()[0];
                IPath path = f.getPath();
                String[] stringArray = this.projectData.packageName.split("\\.");
                int n = stringArray.length;
                int e = 0;
                while (e < n) {
                    String s = stringArray[e];
                    path = path.append(s);
                    p.getProject().getWorkspace().getRoot().getFolder(path).create(true, true, null);
                    ++e;
                }
                IFile cssFile = p.getProject().getWorkspace().getRoot().getFile(path.append("application.css"));
                ByteArrayInputStream in = new ByteArrayInputStream("".getBytes());
                cssFile.create((InputStream)in, 3, null);
                in.close();
                if (this.projectData.mainApp.equals("Desktop")) {
                    mainClass = p.getProject().getWorkspace().getRoot().getFile(path.append("Main.java"));
                    in = new ByteArrayInputStream(new FXProjectMainClassTemplate().generate(this.projectData).toString().getBytes());
                    mainClass.create((InputStream)in, 3, null);
                    in.close();
                } else if (this.projectData.mainApp.equals("Mobile")) {
                    mainClass = p.getProject().getWorkspace().getRoot().getFile(path.append("Main.java"));
                    in = new ByteArrayInputStream(new FXProjectMainMobileClassTemplate().generate(this.projectData).toString().getBytes());
                    mainClass.create((InputStream)in, 3, null);
                    in.close();
                }
                if (!this.projectData.declarativeUiType.equals("None")) {
                    if (!this.projectData.declarativeUiController.trim().isEmpty()) {
                        IFile ctrlClass = p.getProject().getWorkspace().getRoot().getFile(path.append(String.valueOf(this.projectData.declarativeUiController) + ".java"));
                        in = new ByteArrayInputStream(new FXProjectCtrlClassTemplate().generate(this.projectData).toString().getBytes());
                        ctrlClass.create((InputStream)in, 3, null);
                        in.close();
                    }
                    IFile declarativeUi = p.getProject().getWorkspace().getRoot().getFile(path.append(String.valueOf(this.projectData.declarativeUiName) + "." + (this.projectData.declarativeUiType.endsWith("FXML") ? "fxml" : "fxgraph")));
                    in = new ByteArrayInputStream(this.projectData.declarativeUiType.endsWith("FXML") ? new FXProjectFXMLTemplate().generate(this.projectData).toString().getBytes() : new FXProjectFXGraphTemplate().generate(this.projectData).toString().getBytes());
                    declarativeUi.create((InputStream)in, 3, null);
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPart activePart = JavaFXProjectWizard.this.getActivePart();
                    if (activePart instanceof IPackagesViewPart) {
                        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                        view.tryToReveal((Object)newElement);
                    }
                }
            });
        }
        return res;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }

    public static class ProjectData {
        public String mainApp = "Desktop";
        public String packageName = "application";
        public String declarativeUiType = "None";
        public String declarativeUiName = "Sample";
        public String declarativeUiController = "SampleController";
        public String declarativeUiRootType = "javafx.scene.layout.BorderPane";
    }
}

