/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FilterUnits implements Enumerator
{
    USER_SPACE_ON_USE(0, "userSpaceOnUse", "userSpaceOnUse"),
    OBJECT_BOUNDING_BOX(1, "objectBoundingBox", "objectBoundingBox");

    public static final int USER_SPACE_ON_USE_VALUE = 0;
    public static final int OBJECT_BOUNDING_BOX_VALUE = 1;
    private static final FilterUnits[] VALUES_ARRAY;
    public static final List<FilterUnits> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FilterUnits[]{USER_SPACE_ON_USE, OBJECT_BOUNDING_BOX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FilterUnits get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterUnits result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterUnits getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterUnits result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterUnits get(int value) {
        switch (value) {
            case 0: {
                return USER_SPACE_ON_USE;
            }
            case 1: {
                return OBJECT_BOUNDING_BOX;
            }
        }
        return null;
    }

    private FilterUnits(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

