/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import org.eclipse.fx.ui.dialogs.MessageDialog;
import org.eclipse.fx.ui.dialogs.Messages;
import org.eclipse.fx.ui.dialogs.TitleAreaDialog;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MessageTitleDialog
extends TitleAreaDialog {
    private String message;
    private String[] dialogButtonLabels;
    private int okButton;
    private int cancelButton;

    MessageTitleDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message,  @NonNull MessageDialog.Type type, int okButton, int cancelButton, String ... dialogButtonLabels) {
        super(parent, windowTitle, title, null, type.name().toLowerCase());
        this.message = message;
        this.dialogButtonLabels = dialogButtonLabels;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
    }

    @Override
    protected boolean isOkDefault(int buttonId) {
        return this.okButton == buttonId;
    }

    @Override
    protected boolean isCancelDefault(int buttonId) {
        return this.cancelButton == buttonId;
    }

    @Override
    protected List<Button> createButtonsForBar() {
        ArrayList<Button> rv = new ArrayList<Button>();
        int i = 0;
        while (i < this.dialogButtonLabels.length) {
            rv.add(this.createButtonForBar(i, this.dialogButtonLabels[i], this.isOkDefault(i), this.isCancelDefault(i)));
            ++i;
        }
        return rv;
    }

    @Override
    protected Node createDialogContent() {
        BorderPane p = new BorderPane();
        p.setLeft((Node)new Label(this.message));
        return p;
    }

    public static void openErrorDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.ERROR, 0, 0, Messages.getString("MessageTitleDialog.Ok")).open();
    }

    public static void openWarningDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.WARNING, 0, 0, Messages.getString("MessageTitleDialog.Ok")).open();
    }

    public static void openInformationDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.INFORMATION, 0, 0, Messages.getString("MessageTitleDialog.Ok")).open();
    }

    public static MessageDialog.QuestionResult openQuestionDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        return MessageTitleDialog.openQuestionDialog(parent, windowTitle, title, message, MessageDialog.QuestionResult.YES);
    }

    public static MessageDialog.QuestionResult openQuestionDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message,  @NonNull MessageDialog.QuestionResult defaultValue) {
        return MessageDialog.QuestionResult.fromIndex(new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.QUESTION, defaultValue == MessageDialog.QuestionResult.YES ? 0 : 1, defaultValue == MessageDialog.QuestionResult.YES ? 1 : 0, Messages.getString("MessageTitleDialog.Yes"), Messages.getString("MessageTitleDialog.No")).open());
    }

    public static MessageDialog.QuestionCancelResult openQuestionCancelDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        return MessageTitleDialog.openQuestionCancelDialog(parent, windowTitle, title, message, MessageDialog.QuestionCancelResult.YES);
    }

    public static MessageDialog.QuestionCancelResult openQuestionCancelDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message,  @NonNull MessageDialog.QuestionCancelResult defaultValue) {
        int idx;
        switch (defaultValue) {
            case CANCEL: {
                idx = 2;
                break;
            }
            case NO: {
                idx = 1;
                break;
            }
            default: {
                idx = 0;
            }
        }
        return MessageDialog.QuestionCancelResult.fromIndex(new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.QUESTION, idx, 2, Messages.getString("MessageTitleDialog.Yes"), Messages.getString("MessageTitleDialog.No"), Messages.getString("MessageTitleDialog.Cancel")).open());
    }

    public static MessageDialog.ConfirmResult openConfirmDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message) {
        return MessageTitleDialog.openConfirmDialog(parent, windowTitle, title, message, MessageDialog.ConfirmResult.OK);
    }

    public static MessageDialog.ConfirmResult openConfirmDialog(@Nullable Window parent, @NonNull String windowTitle, @NonNull String title, @NonNull String message,  @NonNull MessageDialog.ConfirmResult defaultValue) {
        return MessageDialog.ConfirmResult.fromIndex(new MessageTitleDialog(parent, windowTitle, title, message, MessageDialog.Type.CONFIRM, defaultValue == MessageDialog.ConfirmResult.OK ? 0 : 1, 1, Messages.getString("MessageTitleDialog.Ok"), Messages.getString("MessageTitleDialog.Cancel")).open());
    }
}

