/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.markers;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;

public final class AreaOverlay
extends Region {
    private final BorderPane left;
    private final BorderPane right;
    private final BorderPane top;
    private final BorderPane bottom;
    private final double leftRightRatio;
    private Area activeType = Area.NONE;
    private static final String STYLECLASS_ACTIVE = "active";

    public AreaOverlay(double leftRightRatio) {
        this.setUserData("findNodeExclude");
        this.getStyleClass().add((Object)"area-overlay");
        this.leftRightRatio = leftRightRatio;
        this.left = new BorderPane((Node)new Label("Left"));
        this.left.getStyleClass().addAll((Object[])new String[]{"left", "area"});
        this.right = new BorderPane((Node)new Label("Right"));
        this.right.getStyleClass().addAll((Object[])new String[]{"right", "area"});
        this.top = new BorderPane((Node)new Label("Top"));
        this.top.getStyleClass().addAll((Object[])new String[]{"top", "area"});
        this.bottom = new BorderPane((Node)new Label("Bottom"));
        this.bottom.getStyleClass().addAll((Object[])new String[]{"bottom", "area"});
        this.getChildren().addAll((Object[])new Node[]{this.left, this.right, this.top, this.bottom});
    }

    public void updateActiveArea(Area area) {
        Node oldNode;
        Node newNode = this.getNodeForType(area);
        if (newNode == (oldNode = this.getNodeForType(this.activeType))) {
            return;
        }
        if (oldNode != null) {
            oldNode.getStyleClass().remove((Object)STYLECLASS_ACTIVE);
        }
        if (newNode != null) {
            newNode.getStyleClass().add((Object)STYLECLASS_ACTIVE);
        }
        this.activeType = area;
    }

    private Node getNodeForType(Area area) {
        switch (area) {
            case BOTTOM: {
                return this.bottom;
            }
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
            case TOP: {
                return this.top;
            }
        }
        return null;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Insets pad = this.getPadding();
        double width = this.getWidth() * this.leftRightRatio;
        double height = this.getHeight() - (pad.getTop() + pad.getBottom());
        this.left.resizeRelocate(pad.getLeft(), pad.getTop(), width, height);
        this.right.resizeRelocate(this.getWidth() - pad.getRight() - width, pad.getTop(), width, height);
        this.top.resizeRelocate(this.left.getLayoutX() + this.left.getWidth(), this.left.getLayoutY(), this.getWidth() - width * 2.0, height / 2.0);
        this.bottom.resizeRelocate(this.left.getLayoutX() + this.left.getWidth(), this.top.getLayoutY() + this.top.getHeight(), this.getWidth() - width * 2.0, height / 2.0);
    }

    public static enum Area {
        NONE,
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;

    }
}

