/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.XtextStandaloneSetup;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.MergeableManifest;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorException;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.LanguageModule;
import org.eclipse.xtext.xtext.generator.MweIssues;
import org.eclipse.xtext.xtext.generator.XtextDirectoryCleaner;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.XtextGeneratorStandaloneSetup;
import org.eclipse.xtext.xtext.generator.XtextGeneratorTemplates;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

@Log
public class XtextGenerator
extends AbstractWorkflowComponent2 {
    @Accessors
    private DefaultGeneratorModule configuration = new DefaultGeneratorModule();
    @Accessors
    private final List<XtextGeneratorLanguage> languageConfigs = CollectionLiterals.newArrayList();
    @Accessors
    private XtextDirectoryCleaner cleaner = new XtextDirectoryCleaner();
    @Accessors
    private XtextGeneratorStandaloneSetup standaloneSetup = new XtextGeneratorStandaloneSetup();
    @Accessors
    private String grammarEncoding;
    private Injector injector;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private XtextGeneratorTemplates templates;
    @Inject
    private XtextGeneratorNaming naming;
    @Inject
    private CodeConfig codeConfig;
    private static final Logger LOG = Logger.getLogger(XtextGenerator.class);

    public XtextGenerator() {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    public void addLanguage(XtextGeneratorLanguage language) {
        this.languageConfigs.add(language);
    }

    protected void checkConfigurationInternal(Issues issues) {
        this.initialize();
        MweIssues generatorIssues = new MweIssues(this, issues);
        this.configuration.checkConfiguration(generatorIssues);
        HashMap<String, Grammar> uris = new HashMap<String, Grammar>();
        for (XtextGeneratorLanguage language : this.languageConfigs) {
            language.checkConfiguration(generatorIssues);
            Iterable _filter = Iterables.filter((Iterable)language.getGrammar().getMetamodelDeclarations(), GeneratedMetamodel.class);
            for (GeneratedMetamodel generatedMetamodel : _filter) {
                String nsURI = generatedMetamodel.getEPackage().getNsURI();
                boolean _containsKey = uris.containsKey(nsURI);
                if (_containsKey) {
                    String _name = ((Grammar)uris.get(nsURI)).getName();
                    String _plus = "Duplicate generated grammar with nsURI '" + nsURI + "' in " + _name;
                    String _plus_1 = _plus + " and ";
                    String _name_1 = language.getGrammar().getName();
                    String _plus_2 = _plus_1 + _name_1;
                    generatorIssues.addError(_plus_2);
                    continue;
                }
                uris.put(nsURI, language.getGrammar());
            }
        }
    }

    public void initialize() {
        if (this.injector == null) {
            LOG.info((Object)"Initializing Xtext generator");
            new StandaloneSetup().addRegisterGeneratedEPackage("org.eclipse.xtext.common.types.TypesPackage");
            this.initializeEncoding();
            this.injector = this.createInjector();
            this.injector.injectMembers((Object)this);
            CodeConfig _instance = (CodeConfig)this.injector.getInstance(CodeConfig.class);
            Procedures.Procedure1 _function = it -> it.initialize(this.injector);
            ObjectExtensions.operator_doubleArrow((Object)_instance, (Procedures.Procedure1)_function);
            this.projectConfig.initialize(this.injector);
            this.cleaner.initialize(this.injector);
            this.standaloneSetup.initialize(this.injector);
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                Injector languageInjector = this.createLanguageInjector(this.injector, language);
                language.initialize(languageInjector);
            }
        }
    }

    protected void initializeEncoding() {
        IEncodingProvider encodingProvider;
        String _encoding;
        IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
        Object _get = serviceProviderRegistry.getExtensionToFactoryMap().get("xtext");
        IResourceServiceProvider serviceProvider = (IResourceServiceProvider)_get;
        String _elvis = null;
        _elvis = this.grammarEncoding != null ? this.grammarEncoding : (_encoding = this.configuration.getCode().getEncoding());
        String encoding = _elvis;
        if (serviceProvider != null && encoding != null && (encodingProvider = (IEncodingProvider)serviceProvider.get(IEncodingProvider.class)) instanceof IEncodingProvider.Runtime) {
            ((IEncodingProvider.Runtime)encodingProvider).setDefaultEncoding(encoding);
        }
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{this.configuration});
    }

    protected Injector createLanguageInjector(Injector parent, XtextGeneratorLanguage language) {
        LanguageModule _languageModule = new LanguageModule(language);
        return parent.createChildInjector(new Module[]{_languageModule});
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.initialize();
        try {
            this.cleaner.clean();
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                try {
                    String _name = language.getGrammar().getName();
                    String _plus = "Generating " + _name;
                    LOG.info((Object)_plus);
                    language.generate();
                    this.generateSetups(language);
                    this.generateModules(language);
                    this.generateExecutableExtensionFactory(language);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        this.handleException(e, issues);
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            LOG.info((Object)"Generating common infrastructure");
            this.generatePluginXmls();
            this.generateManifests();
            this.generateActivator();
            this.generateServices();
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                this.handleException(e_1, issues);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    private void handleException(Exception ex, Issues issues) {
        if (ex instanceof CompositeGeneratorException) {
            Consumer<Exception> _function = it -> this.handleException((Exception)it, issues);
            ((CompositeGeneratorException)ex).getExceptions().forEach(_function);
        } else {
            issues.addError((WorkflowComponent)this, "GeneratorException: ", null, (Throwable)ex, null);
        }
    }

    protected void generateSetups(IXtextGeneratorLanguage language) {
        this.templates.createRuntimeGenSetup(language).writeTo(this.projectConfig.getRuntime().getSrcGen());
        this.templates.createRuntimeSetup(language).writeTo(this.projectConfig.getRuntime().getSrc());
        this.templates.createIdeSetup(language).writeTo(this.projectConfig.getGenericIde().getSrc());
        this.templates.createWebSetup(language).writeTo(this.projectConfig.getWeb().getSrc());
    }

    protected void generateModules(IXtextGeneratorLanguage language) {
        this.templates.createRuntimeGenModule(language).writeTo(this.projectConfig.getRuntime().getSrcGen());
        this.templates.createRuntimeModule(language).writeTo(this.projectConfig.getRuntime().getSrc());
        this.templates.createIdeModule(language).writeTo(this.projectConfig.getGenericIde().getSrc());
        this.templates.createIdeGenModule(language).writeTo(this.projectConfig.getGenericIde().getSrcGen());
        this.templates.createEclipsePluginGenModule(language).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        this.templates.createEclipsePluginModule(language).writeTo(this.projectConfig.getEclipsePlugin().getSrc());
        this.templates.createIdeaGenModule(language).writeTo(this.projectConfig.getIdeaPlugin().getSrcGen());
        this.templates.createIdeaModule(language).writeTo(this.projectConfig.getIdeaPlugin().getSrc());
        this.templates.createWebGenModule(language).writeTo(this.projectConfig.getWeb().getSrcGen());
        this.templates.createWebModule(language).writeTo(this.projectConfig.getWeb().getSrc());
    }

    protected void generateExecutableExtensionFactory(IXtextGeneratorLanguage language) {
        boolean _tripleNotEquals;
        IXtextGeneratorFileSystemAccess _srcGen = this.projectConfig.getEclipsePlugin().getSrcGen();
        boolean bl = _tripleNotEquals = _srcGen != null;
        if (_tripleNotEquals) {
            this.templates.createEclipsePluginExecutableExtensionFactory(language, (IXtextGeneratorLanguage)IterableExtensions.head(this.languageConfigs)).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        }
    }

    protected void generateManifests() {
        try {
            Functions.Function1 _function = it -> Tuples.create((Object)it.getManifest(), (Object)it.getMetaInf(), (Object)it.getName());
            List manifests = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.projectConfig.getEnabledProjects(), BundleProjectConfig.class), (Functions.Function1)_function));
            HashMap uri2Manifest = Maps.newHashMapWithExpectedSize((int)manifests.size());
            ListIterator manifestIter = manifests.listIterator();
            while (manifestIter.hasNext()) {
                URI uri;
                boolean _containsKey;
                Triple entry = (Triple)manifestIter.next();
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                if (manifest == null || metaInf == null) {
                    manifestIter.remove();
                    continue;
                }
                if (manifest.getActivator() == null && manifest == this.projectConfig.getEclipsePlugin().getManifest()) {
                    manifest.setActivator(this.naming.getEclipsePluginActivator());
                }
                if (_containsKey = uri2Manifest.containsKey(uri = metaInf.getURI(manifest.getPath()))) {
                    ((ManifestAccess)uri2Manifest.get(uri)).merge(manifest);
                    manifestIter.remove();
                    continue;
                }
                uri2Manifest.put(uri, manifest);
            }
            for (Triple entry : manifests) {
                boolean _isFile;
                boolean _tripleEquals;
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                String _bundleName = manifest.getBundleName();
                boolean bl = _tripleEquals = _bundleName == null;
                if (_tripleEquals) {
                    manifest.setBundleName((String)entry.getThird());
                }
                if (_isFile = metaInf.isFile(manifest.getPath())) {
                    boolean _isMerge = manifest.isMerge();
                    if (_isMerge) {
                        this.mergeManifest(manifest, metaInf);
                        continue;
                    }
                    boolean _endsWith = manifest.getPath().endsWith(".MF");
                    if (!_endsWith) continue;
                    String _path = manifest.getPath();
                    String _plus = _path + "_gen";
                    manifest.setPath(_plus);
                    manifest.writeTo(metaInf);
                    continue;
                }
                manifest.writeTo(metaInf);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeManifest(ManifestAccess manifest, IXtextGeneratorFileSystemAccess metaInf) throws IOException {
        try (InputStream in = null;){
            boolean _isModified;
            in = metaInf.readBinaryFile(manifest.getPath());
            String _bundleName = manifest.getBundleName();
            MergeableManifest merge = new MergeableManifest(in, _bundleName);
            merge.setLineDelimiter(this.codeConfig.getLineDelimiter());
            merge.addExportedPackages(manifest.getExportedPackages());
            merge.addRequiredBundles(manifest.getRequiredBundles());
            merge.addImportedPackages(manifest.getImportedPackages());
            if (manifest.getActivator() != null && StringExtensions.isNullOrEmpty((String)merge.getBundleActivator())) {
                merge.setBundleActivator(manifest.getActivator().getName());
            }
            if (_isModified = merge.isModified()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                merge.write((OutputStream)out);
                byte[] _byteArray = out.toByteArray();
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray);
                metaInf.generateFile(manifest.getPath(), _byteArrayInputStream);
            }
        }
    }

    protected void generateServices() {
        if (this.projectConfig.getGenericIde().getSrcGen() == null || this.languageConfigs.isEmpty()) {
            return;
        }
        TextFileAccess file = new TextFileAccess();
        file.setPath("META-INF/services/org.eclipse.xtext.ISetup");
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                for (XtextGeneratorLanguage lang : XtextGenerator.this.languageConfigs) {
                    TypeReference _genericIdeSetup = XtextGenerator.this.naming.getGenericIdeSetup(lang.getGrammar());
                    _builder.append((Object)_genericIdeSetup);
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        file.setContent(_client);
        file.writeTo(this.projectConfig.getGenericIde().getSrcGen());
    }

    protected void generateActivator() {
        if (this.projectConfig.getEclipsePlugin().getSrcGen() != null && !this.languageConfigs.isEmpty()) {
            this.templates.createEclipsePluginActivator(this.projectConfig, this.languageConfigs).writeTo(this.projectConfig.getEclipsePlugin().getSrcGen());
        }
    }

    protected void generatePluginXmls() {
        Functions.Function1 _function = it -> {
            PluginXmlAccess _pluginXml = it.getPluginXml();
            IXtextGeneratorFileSystemAccess _root = it.getRoot();
            return Pair.of((Object)_pluginXml, (Object)_root);
        };
        List pluginXmls = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter(this.projectConfig.getEnabledProjects(), BundleProjectConfig.class), (Functions.Function1)_function));
        HashMap uri2PluginXml = Maps.newHashMapWithExpectedSize((int)pluginXmls.size());
        ListIterator pluginXmlIter = pluginXmls.listIterator();
        while (pluginXmlIter.hasNext()) {
            Pair entry = (Pair)pluginXmlIter.next();
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            if (pluginXml == null || root == null) {
                pluginXmlIter.remove();
                continue;
            }
            URI uri = root.getURI(pluginXml.getPath());
            boolean _containsKey = uri2PluginXml.containsKey(uri);
            if (_containsKey) {
                ((PluginXmlAccess)uri2PluginXml.get(uri)).merge(pluginXml);
                pluginXmlIter.remove();
                continue;
            }
            uri2PluginXml.put(uri, pluginXml);
        }
        for (Pair entry : pluginXmls) {
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            boolean _isFile = root.isFile(pluginXml.getPath());
            if (_isFile) {
                boolean _endsWith;
                boolean _not;
                boolean _and = false;
                boolean _and_1 = false;
                boolean _isEmpty = pluginXml.getEntries().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) {
                    _and_1 = false;
                } else {
                    String _contentString;
                    boolean _notEquals;
                    CharSequence _readTextFile = root.readTextFile(pluginXml.getPath());
                    String _string = null;
                    if (_readTextFile != null) {
                        _string = _readTextFile.toString();
                    }
                    _and_1 = _notEquals = !Objects.equal((Object)_string, (Object)(_contentString = pluginXml.getContentString()));
                }
                if (!(_and = !_and_1 ? false : (_endsWith = pluginXml.getPath().endsWith(".xml")))) continue;
                String _path = pluginXml.getPath();
                String _plus = _path + "_gen";
                pluginXml.setPath(_plus);
                pluginXml.writeTo(root);
                continue;
            }
            pluginXml.writeTo(root);
        }
    }

    @Pure
    public DefaultGeneratorModule getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DefaultGeneratorModule configuration) {
        this.configuration = configuration;
    }

    @Pure
    public List<XtextGeneratorLanguage> getLanguageConfigs() {
        return this.languageConfigs;
    }

    @Pure
    public XtextDirectoryCleaner getCleaner() {
        return this.cleaner;
    }

    public void setCleaner(XtextDirectoryCleaner cleaner) {
        this.cleaner = cleaner;
    }

    @Pure
    public XtextGeneratorStandaloneSetup getStandaloneSetup() {
        return this.standaloneSetup;
    }

    public void setStandaloneSetup(XtextGeneratorStandaloneSetup standaloneSetup) {
        this.standaloneSetup = standaloneSetup;
    }

    @Pure
    public String getGrammarEncoding() {
        return this.grammarEncoding;
    }

    public void setGrammarEncoding(String grammarEncoding) {
        this.grammarEncoding = grammarEncoding;
    }
}

