/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding.internal;

import javafx.beans.property.ReadOnlyProperty;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableView;
import org.eclipse.fx.ui.databinding.internal.ControlReadOnlyPropertyValueProperty;
import org.eclipse.jdt.annotation.NonNull;

public class SingleSelectionProperty<@NonNull S, T>
extends ControlReadOnlyPropertyValueProperty<S, T> {
    public Object getValueType() {
        return null;
    }

    @Override
    protected ReadOnlyProperty<T> getProperty(S source) {
        SelectionModel<T> model = SingleSelectionProperty.getSelectionModel(source);
        if (model == null) {
            throw new IllegalStateException("Unable to find selection model for '" + source + "'");
        }
        return model.selectedItemProperty();
    }

    static <S, T> SelectionModel<T> getSelectionModel(S source) {
        MultipleSelectionModel m = null;
        if (source instanceof ListView) {
            m = ((ListView)source).getSelectionModel();
        } else if (source instanceof ComboBox) {
            m = ((ComboBox)source).getSelectionModel();
        } else if (source instanceof ChoiceBox) {
            m = ((ChoiceBox)source).getSelectionModel();
        } else if (source instanceof TableView) {
            m = ((TableView)source).getSelectionModel();
        }
        return m;
    }

    protected void doSetValue(S source, T value) {
        SelectionModel<T> o = SingleSelectionProperty.getSelectionModel(source);
        if (o != null) {
            if (value == null) {
                o.clearSelection();
            } else {
                o.select(value);
            }
        }
    }
}

