/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.perspective;

import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.dialogs.TitleAreaDialog;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.perspective.PerspectiveListView;
import org.eclipse.jdt.annotation.Nullable;

public class PerspectiveSwitcherDialog
extends TitleAreaDialog {
    private final MWindow window;
    private final EModelService modelService;
    private final GraphicsLoader graphicsLoader;
    private MPerspective perspectiveToOpen;
    private final EPartService partService;

    @Inject
    public PerspectiveSwitcherDialog(@Nullable Window parent, MWindow window, EModelService modelService, GraphicsLoader graphicsLoader, EPartService partService) {
        super(parent, "Switch perspective", "Switch perspective", "Select a perspective you want to switch to", null);
        this.window = window;
        this.modelService = modelService;
        this.graphicsLoader = graphicsLoader;
        this.partService = partService;
    }

    protected Node createDialogContent() {
        BorderPane parent = new BorderPane();
        PerspectiveListView view = new PerspectiveListView(this.window, this.modelService, this.graphicsLoader);
        view.setOpenConsumer(o -> {
            this.perspectiveToOpen = o;
            this.okPressed();
        });
        view.setSelectionConsumer(o -> {
            this.perspectiveToOpen = o;
        });
        view.init(parent);
        return parent;
    }

    protected void okPressed() {
        if (this.perspectiveToOpen != null) {
            super.okPressed();
            this.partService.switchPerspective(this.perspectiveToOpen);
        }
    }
}

