/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.util;

import com.google.common.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import org.eclipse.xtext.nodemodel.BidiIterator;

public class SingletonBidiIterator<T>
extends UnmodifiableIterator<T>
implements BidiIterator<T> {
    private boolean doneNext;
    private boolean donePrevious;
    private final T value;

    public static <T> BidiIterator<T> create(T t) {
        return new SingletonBidiIterator<T>(t);
    }

    private SingletonBidiIterator(T value) {
        this.value = value;
        this.doneNext = false;
        this.donePrevious = false;
    }

    @Override
    public boolean hasNext() {
        return !this.doneNext;
    }

    @Override
    public T next() {
        if (this.doneNext) {
            throw new NoSuchElementException();
        }
        this.doneNext = true;
        this.donePrevious = false;
        return this.value;
    }

    @Override
    public boolean hasPrevious() {
        return !this.donePrevious;
    }

    @Override
    public T previous() {
        if (this.donePrevious) {
            throw new NoSuchElementException();
        }
        this.donePrevious = true;
        this.doneNext = false;
        return this.value;
    }
}

