/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 1L;

    public SimpleDateFormat() {
        super(new java.text.SimpleDateFormat());
    }

    public SimpleDateFormat(String pattern) {
        super(new java.text.SimpleDateFormat(pattern));
    }

    public SimpleDateFormat(String pattern, Locale loc) {
        super(new java.text.SimpleDateFormat(pattern, loc));
    }

    public SimpleDateFormat(String pattern, ULocale loc) {
        this(pattern, loc.toLocale());
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatData) {
        super(new java.text.SimpleDateFormat(pattern, formatData.dfs));
    }

    public void set2DigitYearStart(Date startDate) {
        ((java.text.SimpleDateFormat)this.dateFormat).set2DigitYearStart(startDate);
    }

    public Date get2DigitYearStart() {
        return ((java.text.SimpleDateFormat)this.dateFormat).get2DigitYearStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(com.ibm.icu.util.Calendar cal, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer result;
        FieldPosition jdkPos = SimpleDateFormat.toJDKFieldPosition(pos);
        java.text.DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            Calendar oldCal = this.dateFormat.getCalendar();
            this.dateFormat.setCalendar(cal.calendar);
            result = this.dateFormat.format(cal.getTime(), toAppendTo, jdkPos);
            this.dateFormat.setCalendar(oldCal);
        }
        if (jdkPos != null) {
            pos.setBeginIndex(jdkPos.getBeginIndex());
            pos.setEndIndex(jdkPos.getEndIndex());
        }
        return result;
    }

    @Override
    public void setNumberFormat(NumberFormat newNumberFormat) {
        super.setNumberFormat(newNumberFormat);
    }

    @Override
    public void parse(String text, com.ibm.icu.util.Calendar cal, ParsePosition parsePos) {
        cal.setTime(this.dateFormat.parse(text, parsePos));
    }

    public String toPattern() {
        return ((java.text.SimpleDateFormat)this.dateFormat).toPattern();
    }

    public String toLocalizedPattern() {
        return ((java.text.SimpleDateFormat)this.dateFormat).toLocalizedPattern();
    }

    public void applyPattern(String pat) {
        ((java.text.SimpleDateFormat)this.dateFormat).applyPattern(pat);
    }

    public void applyLocalizedPattern(String pat) {
        ((java.text.SimpleDateFormat)this.dateFormat).applyLocalizedPattern(pat);
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return new DateFormatSymbols(((java.text.SimpleDateFormat)this.dateFormat).getDateFormatSymbols());
    }

    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        ((java.text.SimpleDateFormat)this.dateFormat).setDateFormatSymbols(newFormatSymbols.dfs);
    }

    private SimpleDateFormat(java.text.SimpleDateFormat sdf) {
        super(sdf);
    }

    @Override
    public Object clone() {
        return new SimpleDateFormat((java.text.SimpleDateFormat)this.dateFormat.clone());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        AttributedCharacterIterator it = this.dateFormat.formatToCharacterIterator(obj);
        StringBuilder sb = new StringBuilder();
        char c = it.first();
        while (c != '\uffff') {
            sb.append(c);
            c = it.next();
        }
        AttributedString attrstr = new AttributedString(sb.toString());
        int idx = 0;
        it.first();
        while (idx < it.getEndIndex()) {
            int end = it.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> attributes = it.getAttributes();
            if (attributes != null) {
                for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : attributes.entrySet()) {
                    AttributedCharacterIterator.Attribute attr = entry.getKey();
                    Object val = entry.getValue();
                    if (attr.equals(DateFormat.Field.AM_PM)) {
                        attr = DateFormat.Field.AM_PM;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.DAY_OF_MONTH)) {
                        attr = DateFormat.Field.DAY_OF_MONTH;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.DAY_OF_WEEK)) {
                        attr = DateFormat.Field.DAY_OF_WEEK;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.DAY_OF_WEEK_IN_MONTH)) {
                        attr = DateFormat.Field.DAY_OF_WEEK_IN_MONTH;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.DAY_OF_YEAR)) {
                        attr = DateFormat.Field.DAY_OF_YEAR;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.ERA)) {
                        attr = DateFormat.Field.ERA;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.HOUR_OF_DAY0)) {
                        attr = DateFormat.Field.HOUR_OF_DAY0;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.HOUR_OF_DAY1)) {
                        attr = DateFormat.Field.HOUR_OF_DAY1;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.HOUR0)) {
                        attr = DateFormat.Field.HOUR0;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.HOUR1)) {
                        attr = DateFormat.Field.HOUR1;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.MILLISECOND)) {
                        attr = DateFormat.Field.MILLISECOND;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.MINUTE)) {
                        attr = DateFormat.Field.MINUTE;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.MONTH)) {
                        attr = DateFormat.Field.MONTH;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.SECOND)) {
                        attr = DateFormat.Field.SECOND;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.TIME_ZONE)) {
                        attr = DateFormat.Field.TIME_ZONE;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.WEEK_OF_MONTH)) {
                        attr = DateFormat.Field.WEEK_OF_MONTH;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.WEEK_OF_YEAR)) {
                        attr = DateFormat.Field.WEEK_OF_YEAR;
                        val = attr;
                    } else if (attr.equals(DateFormat.Field.YEAR)) {
                        attr = DateFormat.Field.YEAR;
                        val = attr;
                    }
                    attrstr.addAttribute(attr, val, idx, end);
                }
            }
            idx = end;
            while (it.getIndex() < idx) {
                it.next();
            }
        }
        return attrstr.getIterator();
    }
}

