/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.Analyzable;
import org.eclipse.xtend.expression.Evaluatable;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends SyntaxElement
implements Analyzable,
Evaluatable {
    protected Type findType(Identifier type, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type toCast = ctx.getTypeForName(type.toString());
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, type.toString(), type));
        }
        return toCast;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object evaluate(ExecutionContext ctx) {
        Object object;
        Object evaluateInternal = null;
        try {
            ProgressMonitor monitor = ctx.getMonitor();
            if (monitor != null && monitor.isCanceled() || ctx.getCallback() != null && !ctx.getCallback().pre(this, ctx)) {
                if (ctx.getCallback() != null) {
                    ctx.getCallback().post(this, ctx, evaluateInternal);
                }
                return null;
            }
            object = evaluateInternal = this.evaluateInternal(ctx);
        }
        catch (EvaluationException ex) {
            ctx.handleRuntimeException(ex, this, null);
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(this, ctx, evaluateInternal);
            }
            return null;
            {
                catch (Throwable throwable) {
                    if (ctx.getCallback() != null) {
                        ctx.getCallback().post(this, ctx, evaluateInternal);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException ex2) {
                ctx.handleRuntimeException(new EvaluationException(ex2, (SyntaxElement)this, ctx), this, null);
                if (ctx.getCallback() != null) {
                    ctx.getCallback().post(this, ctx, evaluateInternal);
                }
                return null;
            }
        }
        if (ctx.getCallback() != null) {
            ctx.getCallback().post(this, ctx, evaluateInternal);
        }
        return object;
    }

    @Override
    public Type analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type val = null;
        VetoableCallback callback = ctx.getCallback();
        try {
            if (callback != null && !callback.pre(this, ctx)) {
                return null;
            }
            Type type = val = this.analyzeInternal(ctx, issues);
            return type;
        }
        catch (RuntimeException ex) {
            if (ex.getMessage() != null) {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, ex.getMessage(), this));
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Syntax Error", this));
            }
            return null;
        }
        finally {
            if (callback != null) {
                callback.post(this, ctx, val);
            }
        }
    }

    protected abstract Type analyzeInternal(ExecutionContext var1, Set<AnalysationIssue> var2);

    public final String toString() {
        return this.toStringInternal();
    }

    protected abstract String toStringInternal();

    protected abstract Object evaluateInternal(ExecutionContext var1);
}

