/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.ContextBoundValue;
import org.eclipse.fx.core.di.ContextScope;
import org.eclipse.fx.core.di.context.ScopeCalculator;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EclipseContextBoundValue<T>
implements ContextBoundValue<T> {
    private @NonNull IEclipseContext context;
    private @Nullable String contextKey;
    @Nullable List<Callback<T>> callbacks;
    @Nullable List<Callback<Void>> disposalCallbacks;
    private @NonNull AdapterService adapterService;
    boolean contextDisposed;
    @Inject
    @Optional
    @Nullable IEventBroker eventBroker;
    @Inject
    @Log
    private Logger logger;
    private ContextScope scope;
    private final @NonNull ScopeCalculator scopeCalculator;

    @Inject
    public EclipseContextBoundValue(@NonNull IEclipseContext context, @NonNull AdapterService adapterService, @NonNull ScopeCalculator scopeCalculator) {
        this.context = context;
        this.adapterService = adapterService;
        this.scopeCalculator = scopeCalculator;
    }

    public void setContextKey(@NonNull String contextKey, ContextScope scope) {
        this.contextKey = contextKey;
        this.scope = scope;
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (EclipseContextBoundValue.this.contextDisposed) {
                    return false;
                }
                EclipseContextBoundValue.this.notifySubscriptions(EclipseContextBoundValue.this.getValue());
                return true;
            }
        });
    }

    void notifySubscriptions(@Nullable T newValue) {
        if (this.callbacks != null) {
            Callback[] callbackArray = this.callbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback c = callbackArray[n2];
                try {
                    c.call(newValue);
                }
                catch (Throwable t) {
                    this.logger.error("Failed while executing callback", t);
                }
                ++n2;
            }
        }
    }

    public @Nullable T getValue() {
        this.checkContextDisposed();
        if (this.contextKey == null) {
            return null;
        }
        return (T)this.context.get(this.contextKey);
    }

    public void publish(@Nullable T value) {
        this.checkContextDisposed();
        if (this.scope == ContextScope.LOCAL) {
            this.context.set(this.contextKey, value);
        } else if (this.scope == ContextScope.APPLICATION) {
            this.scopeCalculator.getContext(this.context, this.scope).orElse(this.context).set(this.contextKey, value);
        } else {
            this.context.modify(this.contextKey, value);
        }
        if (this.eventBroker != null) {
            this.eventBroker.send("org/eclipse/fx/context/key", Collections.singletonMap(this.contextKey, value));
        }
    }

    public Subscription subscribeOnValueChange(final Callback<T> callback) {
        this.checkContextDisposed();
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback<T>>();
        }
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List callbacks = EclipseContextBoundValue.this.callbacks;
                if (callbacks != null) {
                    callbacks.remove(callback);
                }
            }
        };
    }

    public Subscription subscribeOnDispose(final Callback<Void> callback) {
        this.checkContextDisposed();
        if (this.disposalCallbacks == null) {
            this.disposalCallbacks = new ArrayList<Callback<Void>>();
        }
        if (this.disposalCallbacks != null) {
            this.disposalCallbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List<Callback<Void>> disposalCallbacks = EclipseContextBoundValue.this.disposalCallbacks;
                if (disposalCallbacks != null) {
                    disposalCallbacks.remove(callback);
                }
            }
        };
    }

    public <A> A adaptTo(@NonNull Class<A> adapt) {
        this.checkContextDisposed();
        return (A)this.adapterService.adapt((Object)this, adapt, new AdapterService.ValueAccess[]{new ValueAccessImpl(this.context)});
    }

    public boolean canAdaptTo(Class<?> adapt) {
        this.checkContextDisposed();
        return this.adapterService.canAdapt((Object)this, adapt);
    }

    @PreDestroy
    void dispose() {
        this.contextDisposed = true;
        List<Callback<Void>> disposalCallbacks = this.disposalCallbacks;
        if (disposalCallbacks != null) {
            Callback[] callbackArray = disposalCallbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                try {
                    callback.call(null);
                }
                catch (Throwable t) {
                    this.logger.error("Failure while executing clean up callback", t);
                }
                ++n2;
            }
            disposalCallbacks.clear();
        }
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }

    private void checkContextDisposed() {
        if (this.contextDisposed) {
            this.logger.warningf("Context was already disposed. ContextKey=%s is not accessible anymore.", (Throwable)new Exception(), new Object[]{this.contextKey});
        }
    }

    static class ValueAccessImpl
    implements AdapterService.ValueAccess {
        private final IEclipseContext context;

        public ValueAccessImpl(IEclipseContext context) {
            this.context = context;
        }

        public <O> O getValue(String key) {
            return (O)this.context.get(key);
        }

        public <O> O getValue(@NonNull Class<O> key) {
            return (O)this.context.get(key);
        }
    }
}

