/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.util.concurrent.IWriteAccess;

public abstract class AbstractReadWriteAcces<State>
implements IReadAccess<State>,
IWriteAccess<State> {
    private static Logger log = Logger.getLogger(AbstractReadWriteAcces.class);
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();
    private ThreadLocal<Integer> readLockCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected abstract State getState();

    @Override
    public <Result> Result readOnly(IUnitOfWork<Result, State> work) {
        this.acquireReadLock();
        try {
            State state = this.getState();
            this.beforeReadOnly(state, work);
            Result exec = work.exec(state);
            this.afterReadOnly(state, exec, work);
            Result Result = exec;
            return Result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Result> Result modify(IUnitOfWork<Result, State> work) {
        this.acquireWriteLock();
        State state = null;
        Result exec = null;
        try {
            state = this.getState();
            this.beforeModify(state, work);
            Result Result = exec = (Result)work.exec(state);
            return Result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            this.releaseWriteLock();
            try {
                this.acquireReadLock();
                this.afterModify(state, exec, work);
            }
            finally {
                this.releaseReadLock();
            }
        }
    }

    public <Result> Result process(IUnitOfWork<Result, State> work) {
        this.releaseReadLock();
        this.acquireWriteLock();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("process - " + Thread.currentThread().getName()));
            }
            Result Result = this.modify(work);
            return Result;
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Downgrading from write lock to read lock...");
            }
            this.acquireReadLock();
            this.releaseWriteLock();
        }
    }

    protected void beforeModify(State state, IUnitOfWork<?, State> work) {
    }

    protected void beforeReadOnly(State state, IUnitOfWork<?, State> work) {
    }

    protected void afterModify(State state, Object result, IUnitOfWork<?, State> work) {
    }

    protected void afterReadOnly(State state, Object result, IUnitOfWork<?, State> work) {
    }

    protected int getWriteHoldCount() {
        return this.rwLock.getWriteHoldCount();
    }

    protected int getReadHoldCount() {
        return this.readLockCount.get();
    }

    private void acquireReadLock() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Trying to acquire read lock...");
        }
        this.readLock.lock();
        this.readLockCount.set(this.readLockCount.get() + 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)"...read lock acquired.");
        }
    }

    private void releaseReadLock() {
        this.readLock.unlock();
        this.readLockCount.set(this.readLockCount.get() - 1);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Read lock released.");
        }
    }

    private void acquireWriteLock() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Trying to acquire write lock...");
        }
        this.writeLock.lock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"...write lock acquired.");
        }
    }

    private void releaseWriteLock() {
        this.writeLock.unlock();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Write lock released.");
        }
    }
}

