/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.fx.core.Range;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.AnnotatedString;
import org.eclipse.fx.ui.controls.styledtext_ng.StyledLineRenderer;
import org.eclipse.fx.ui.controls.styledtext_ng.StyledLineRendererFactory;

public class StyledLine
extends Region {
    private final StyledLineRenderer renderer;
    private final List<Subscription> ranges = new ArrayList<Subscription>();

    public StyledLine(StyledLineRendererFactory factory) {
        this.renderer = factory.createRenderer();
        Node node = this.renderer.getNode();
        this.getChildren().add((Object)node);
    }

    protected void layoutChildren() {
        this.getManagedChildren().forEach(c -> c.resizeRelocate(0.0, 0.0, c.prefWidth(-1.0), c.prefHeight(-1.0)));
    }

    public void setVisibleRange(double minX, double maxX) {
        this.renderer.setVisibleRange(minX, maxX);
    }

    public void setText(AnnotatedString<String> string) {
        HashMap map = new HashMap();
        this.renderer.combinedAction(() -> {
            this.ranges.forEach(Subscription::dispose);
            string.forEachSegment((segIdx, start, end, annotations) -> {
                SegmentNode node = map.computeIfAbsent(Arrays.asList(annotations), l -> new SegmentNode((List<String>)l, this.renderer));
                this.ranges.add(node.addRange(new Range(start, end)));
            });
            this.renderer.setText(string.toString().toCharArray());
        });
        this.getChildren().addAll(map.values());
    }

    public void setFont(String family, double size) {
        this.renderer.setFont(family, size);
    }

    static class SegmentNode
    extends Group {
        final StyledLineRenderer renderer;
        final List<Range> ranges = new ArrayList<Range>();
        List<Subscription> boldSubscriptions = new ArrayList<Subscription>();
        List<Subscription> italicSubscriptions = new ArrayList<Subscription>();
        List<Subscription> fillSubscriptions = new ArrayList<Subscription>();
        private static StyleablePropertyFactory<SegmentNode> FACTORY = new StyleablePropertyFactory(Group.getClassCssMetaData());
        private static final CssMetaData<SegmentNode, Boolean> BOLD = FACTORY.createBooleanCssMetaData("-efx-styled-bold", s -> s.bold, false, false);
        private static final CssMetaData<SegmentNode, Boolean> ITALIC = FACTORY.createBooleanCssMetaData("-efx-styled-italic", s -> s.italic, false, false);
        private static final CssMetaData<SegmentNode, Paint> FILL = FACTORY.createPaintCssMetaData("-efx-fill", s -> s.fill, (Paint)Color.BLACK, false);
        private final StyleableProperty<Boolean> bold = new SimpleStyleableBooleanProperty(BOLD, (Object)this, "bold"){

            protected void invalidated() {
                super.invalidated();
                renderer.combinedAction(() -> {
                    boldSubscriptions.forEach(Subscription::dispose);
                    boldSubscriptions.clear();
                    if (this.get()) {
                        boldSubscriptions = ranges.stream().map(renderer::setBold).collect(Collectors.toList());
                    }
                });
            }
        };
        private final StyleableProperty<Boolean> italic = new SimpleStyleableBooleanProperty(ITALIC, (Object)this, "italic"){

            protected void invalidated() {
                super.invalidated();
                renderer.combinedAction(() -> {
                    italicSubscriptions.forEach(Subscription::dispose);
                    italicSubscriptions.clear();
                    if (this.get()) {
                        italicSubscriptions = ranges.stream().map(renderer::setItalic).collect(Collectors.toList());
                    }
                });
            }
        };
        private final StyleableProperty<Paint> fill = new SimpleStyleableObjectProperty<Paint>(FILL, (Object)this, "fill", (Paint)Color.BLACK){

            protected void invalidated() {
                super.invalidated();
                renderer.combinedAction(() -> {
                    Paint p = (Paint)this.get();
                    fillSubscriptions.forEach(Subscription::dispose);
                    fillSubscriptions.clear();
                    fillSubscriptions = ranges.stream().map(r -> renderer.setForeground(p, (Range)r)).collect(Collectors.toList());
                });
            }
        };

        public SegmentNode(List<String> styleclasses, StyledLineRenderer renderer) {
            this.setManaged(false);
            this.renderer = renderer;
            this.getStyleClass().setAll(styleclasses);
        }

        public Subscription addRange(Range r) {
            this.ranges.add(r);
            if (((Boolean)this.bold.getValue()).booleanValue()) {
                this.boldSubscriptions.add(this.renderer.setBold(r));
            }
            if (((Boolean)this.italic.getValue()).booleanValue()) {
                this.italicSubscriptions.add(this.renderer.setItalic(r));
            }
            this.fillSubscriptions.add(this.renderer.setForeground((Paint)this.fill.getValue(), r));
            return () -> {
                if (((Boolean)this.bold.getValue()).booleanValue()) {
                    this.boldSubscriptions.add(this.renderer.setBold(r));
                }
                if (((Boolean)this.italic.getValue()).booleanValue()) {
                    this.italicSubscriptions.add(this.renderer.setItalic(r));
                }
                this.fillSubscriptions.add(this.renderer.setForeground((Paint)this.fill.getValue(), r));
                this.ranges.remove(r);
            };
        }

        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return FACTORY.getCssMetaData();
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return FACTORY.getCssMetaData();
        }
    }
}

