/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

public class MavenWorkspaceRuntime
extends AbstractMavenRuntime {
    private static final ArtifactKey MAVEN_DISTRIBUTION = new ArtifactKey("org.apache.maven", "apache-maven", "[3.0,)", null);
    private static final ArtifactKey PLEXUS_CLASSWORLDS = new ArtifactKey("org.codehaus.plexus", "plexus-classworlds", null, null);
    private static final String MAVEN_EXECUTOR_CLASS = "org.apache.maven.cli.MavenCli";
    private static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    public MavenWorkspaceRuntime(String name) {
        super(name);
    }

    protected ArtifactKey getDistributionArtifactKey() {
        return MAVEN_DISTRIBUTION;
    }

    protected String getMainClass() {
        return MAVEN_EXECUTOR_CLASS;
    }

    @Override
    public String getLocation() {
        return "WORKSPACE";
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return this.getMavenDistribution() != null && this.isSupportedVersion();
    }

    protected IMavenProjectFacade getMavenDistribution() {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)this.getDistributionArtifactKey().getVersion());
            IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                ArtifactKey artifactKey = facade.getArtifactKey();
                if (this.getDistributionArtifactKey().getGroupId().equals(artifactKey.getGroupId()) && this.getDistributionArtifactKey().getArtifactId().equals(artifactKey.getArtifactId()) && range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifactKey.getVersion()))) {
                    return facade;
                }
                ++n2;
            }
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void createLauncherConfiguration(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            MavenProject mavenProject = maven.getMavenProject(monitor);
            collector.setMainType(this.getMainClass(), PLEXUS_CLASSWORLD_NAME);
            collector.addRealm(PLEXUS_CLASSWORLD_NAME);
            this.collectExtensions(collector, monitor);
            IMavenProjectFacade[] iMavenProjectFacadeArray = projectManager.getProjects();
            int n = iMavenProjectFacadeArray.length;
            int n2 = 0;
            while (n2 < n) {
                File loggingConfigurationDirectory;
                IMavenProjectFacade facade = iMavenProjectFacadeArray[n2];
                ArtifactKey artifactKey = facade.getArtifactKey();
                if (this.getDistributionArtifactKey().getGroupId().equals(artifactKey.getGroupId()) && this.getDistributionArtifactKey().getArtifactId().equals(artifactKey.getArtifactId()) && (loggingConfigurationDirectory = new File(facade.getPomFile().getParentFile(), "src/conf/logging")).exists()) {
                    collector.addArchiveEntry(loggingConfigurationDirectory.getAbsolutePath());
                }
                ++n2;
            }
            Set artifacts = mavenProject.getArtifacts();
            Artifact launcherArtifact = null;
            for (Artifact artifact : artifacts) {
                if ("test".equals(artifact.getScope())) continue;
                if (PLEXUS_CLASSWORLDS.getGroupId().equals(artifact.getGroupId()) && PLEXUS_CLASSWORLDS.getArtifactId().equals(artifact.getArtifactId())) {
                    launcherArtifact = artifact;
                    continue;
                }
                this.addArtifact(collector, artifact);
            }
            if (launcherArtifact != null) {
                collector.addRealm("]launcher");
                this.addArtifact(collector, launcherArtifact);
            }
        }
    }

    public String toString() {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            return String.valueOf(maven.getProject().getName()) + ' ' + maven.getArtifactKey().getVersion();
        }
        return this.getDistributionArtifactKey().getVersion();
    }

    protected void addArtifact(IMavenLauncherConfiguration collector, Artifact artifact) throws CoreException {
        IMavenProjectFacade facade = projectManager.getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (facade != null) {
            collector.addProjectEntry(facade);
        } else {
            File file = artifact.getFile();
            if (file != null) {
                collector.addArchiveEntry(file.getAbsolutePath());
            }
        }
    }

    @Override
    public String getVersion() {
        IMavenProjectFacade maven = this.getMavenDistribution();
        if (maven != null) {
            return maven.getArtifactKey().getVersion();
        }
        return this.getDistributionArtifactKey().getVersion();
    }
}

