/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.ast.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.internal.core.ast.parser.Location;

public class XmlLocationAnalyser {
    private Map<String, XmlFileEvaluator> repository = new HashMap<String, XmlFileEvaluator>();
    protected ResourceLoader loader;

    public Location adapt(Location loc) {
        String resource = loc.getResource();
        XmlFileEvaluator evaluator = this.evaluateResource(resource);
        return evaluator.adapt(loc);
    }

    public Location adaptEnd(Location loc) {
        String resource = loc.getResource();
        XmlFileEvaluator evaluator = this.evaluateResource(resource);
        return evaluator.adaptEnd(loc);
    }

    public int findFirstLineOfTag(String resource, int lineNumber) {
        if (!this.repository.containsKey(resource)) {
            this.evaluateResource(resource);
        }
        return this.repository.get(resource).findFirstLineOfTag(lineNumber);
    }

    private XmlFileEvaluator evaluateResource(String resource) {
        if (this.loader == null) {
            this.loader = ResourceLoaderFactory.createResourceLoader();
        }
        InputStream is = this.loader.getResourceAsStream(resource);
        XmlFileEvaluator evaluator = new XmlFileEvaluator();
        evaluator.evaluate(is);
        this.repository.put(resource, evaluator);
        return evaluator;
    }

    protected XmlFileEvaluator newEvaluator() {
        return new XmlFileEvaluator();
    }

    public XmlFileEvaluator newEvaluator__TEST() {
        return this.newEvaluator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class XmlFileEvaluator {
        private List<XmlTagValues> values = new ArrayList<XmlTagValues>();
        private List<Object[]> result;
        protected StringBuffer otherText;
        protected StringBuffer name;
        protected StringBuffer specChar;
        protected boolean inTag;
        protected boolean isClosingTag;
        protected boolean inName;
        protected boolean inInstruction;
        protected boolean inComment = false;

        public void evaluate(InputStream is) {
            if (is == null) {
                return;
            }
            this.result = new ArrayList<Object[]>();
            int offset = 0;
            int column = 0;
            int nameStart = 0;
            int nameEnd = 0;
            int line = 0;
            int tagLine = 0;
            int firstColumn = 0;
            this.reset();
            try {
                int c;
                while ((c = is.read()) != -1) {
                    switch (c) {
                        case 60: {
                            if (!(this.inTag || this.inInstruction || this.inComment)) {
                                this.inTag = true;
                                tagLine = line;
                                break;
                            }
                            this.consume(c);
                            break;
                        }
                        case 62: {
                            if (this.inTag) {
                                if (nameEnd == 0) {
                                    nameEnd = offset - this.specChar.length();
                                }
                                if (line != tagLine) {
                                    firstColumn = 0;
                                }
                                XmlTagValues value = new XmlTagValues();
                                value.firstLineOfTag = tagLine + 1;
                                value.lastLineOfTag = line + 1;
                                value.nameStart = nameStart;
                                value.nameEnd = nameEnd;
                                value.firstColumn = firstColumn - (this.isClosingTag ? 1 : 0);
                                value.endColumn = column + 1;
                                value.name = this.name.toString();
                                value.isClosingTag = this.isClosingTag;
                                this.values.add(value);
                                this.result.add(new Object[]{new String[]{this.name.toString(), this.otherText.toString()}, value});
                                this.reset();
                                nameEnd = 0;
                                break;
                            }
                            if (this.inInstruction && this.specChar.toString().endsWith("?")) {
                                this.reset();
                                break;
                            }
                            if (this.inComment && this.specChar.toString().endsWith("--")) {
                                this.reset();
                                break;
                            }
                            this.consume(c);
                            break;
                        }
                        case 47: {
                            if (this.inTag && !this.inInstruction && this.name.length() == 0) {
                                this.isClosingTag = true;
                            }
                            this.specChar.append((char)c);
                            break;
                        }
                        case 33: {
                            if (this.inTag && !this.inInstruction && this.name.length() == 0) {
                                this.specChar.append((char)c);
                                break;
                            }
                            this.consume(c);
                            break;
                        }
                        case 45: {
                            if (this.inTag && this.name.length() == 0 || this.inComment) {
                                this.specChar.append((char)c);
                            } else {
                                this.consume(c);
                            }
                            if (!this.specChar.toString().endsWith("!--")) break;
                            this.inTag = false;
                            this.inInstruction = false;
                            this.inComment = true;
                            break;
                        }
                        case 63: {
                            if (this.inTag && !this.inInstruction && this.name.length() == 0) {
                                this.inTag = false;
                                this.inInstruction = true;
                                break;
                            }
                            if (this.inInstruction) {
                                this.specChar.append((char)c);
                                break;
                            }
                            this.consume(c);
                            break;
                        }
                        case 9: 
                        case 32: {
                            if (this.inName) {
                                this.inName = false;
                                nameEnd = offset - this.specChar.length();
                            }
                            this.consume(c);
                            break;
                        }
                        case 13: {
                            this.specChar.append((char)c);
                            ++line;
                            column = -1;
                            break;
                        }
                        case 10: {
                            if (!this.specChar.toString().endsWith("\r")) {
                                ++line;
                                column = -1;
                            }
                            if (this.inName) {
                                this.inName = false;
                                nameEnd = offset - this.specChar.length();
                            }
                            this.consume(c);
                            break;
                        }
                        default: {
                            if (this.inTag && !this.inName && this.name.length() == 0) {
                                this.specChar = new StringBuffer();
                                this.inName = true;
                                nameStart = offset;
                                firstColumn = column;
                            }
                            this.consume(c);
                        }
                    }
                    ++offset;
                    ++column;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void consume(int c) {
            if (this.inName) {
                this.name.append(String.valueOf(this.specChar.toString()) + (char)c);
            } else if (this.name.length() > 0) {
                this.otherText.append(String.valueOf(this.specChar.toString()) + (char)c);
            }
            if (this.specChar.length() > 0) {
                this.specChar = new StringBuffer();
            }
        }

        private void reset() {
            this.otherText = new StringBuffer();
            this.name = new StringBuffer();
            this.specChar = new StringBuffer();
            this.inTag = false;
            this.isClosingTag = false;
            this.inName = false;
            this.inInstruction = false;
            this.inComment = false;
        }

        protected int findFirstLineOfTag(int lineNumber) {
            for (XmlTagValues value : this.values) {
                if (lineNumber < value.firstLineOfTag || lineNumber > value.lastLineOfTag) continue;
                return value.firstLineOfTag;
            }
            return -1;
        }

        public Location adapt(Location rawLoc) {
            XmlTagValues value = this.findLine(rawLoc);
            if (value == null) {
                return null;
            }
            Location loc = new Location(value.firstLineOfTag, 0, rawLoc.getResource());
            loc.setNameStart(value.nameStart);
            loc.setNameEnd(value.nameEnd);
            return loc;
        }

        protected Location adaptEnd(Location rawLoc) {
            int line = rawLoc.getLineNumber();
            int col = rawLoc.getColumnNumber();
            String name1 = null;
            XmlTagValues potentialValue = null;
            for (XmlTagValues value : this.values) {
                if (name1 == null && line == value.firstLineOfTag && col >= value.firstColumn && col <= value.endColumn) {
                    name1 = value.name;
                }
                if (name1 == null && line < value.firstLineOfTag && potentialValue != null) {
                    name1 = potentialValue.name;
                } else if (value.name.equals(name1) && value.isClosingTag) {
                    Location loc = new Location(value.firstLineOfTag, 0, rawLoc.getResource());
                    loc.setNameStart(value.nameStart);
                    loc.setNameEnd(value.nameEnd);
                    return loc;
                }
                potentialValue = value;
            }
            return null;
        }

        protected XmlTagValues findLine(Location loc) {
            if (this.values.isEmpty()) {
                return null;
            }
            int line = loc.getRawLineNumber();
            int col = loc.getColumnNumber();
            ArrayList<XmlTagValues> potentialValues = new ArrayList<XmlTagValues>();
            XmlTagValues value = null;
            for (XmlTagValues nextValue : this.values) {
                if (value == null) {
                    value = nextValue;
                    if (line >= value.firstLineOfTag) continue;
                    potentialValues.add(value);
                    break;
                }
                if (line >= value.firstLineOfTag && line < nextValue.firstLineOfTag || value.firstLineOfTag == nextValue.firstLineOfTag) {
                    potentialValues.add(value);
                }
                value = nextValue;
            }
            if (potentialValues.isEmpty() || value != null && line == value.firstLineOfTag) {
                potentialValues.add(value);
            }
            value = this.handleColumns(col, potentialValues);
            return value;
        }

        protected XmlTagValues handleColumns(int col, List<XmlTagValues> values) {
            if (values.size() == 1) {
                return values.get(0);
            }
            XmlTagValues value = null;
            for (XmlTagValues nextValue : values) {
                if (value == null) {
                    value = nextValue;
                    if (col >= value.firstColumn) continue;
                    return value;
                }
                if (col >= value.firstColumn && col < nextValue.firstColumn) {
                    return value;
                }
                value = nextValue;
            }
            return value;
        }

        public List<Object[]> getResult() {
            return this.result;
        }
    }

    protected class XmlTagValues {
        public int firstLineOfTag;
        int lastLineOfTag;
        public int nameStart;
        public int nameEnd;
        int firstColumn;
        int endColumn;
        boolean isClosingTag;
        String name;

        protected XmlTagValues() {
        }
    }
}

