/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstState;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstTransition;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstructionNFAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class TreeConstNFAToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<TreeConstState, TreeConstTransition> nfaProvider = new TreeConstructionNFAProvider();

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement grammarElement, GraphvizDotBuilder.Digraph digraph) {
        GraphvizDotBuilder.Node node = super.drawAbstractElementTree(grammarElement, digraph);
        TreeConstState nfas = this.nfaProvider.getNFA(grammarElement);
        for (TreeConstTransition outgoing : nfas.getOutgoing()) {
            digraph.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(grammarElement, outgoing, false));
        }
        for (TreeConstTransition outgoingAfterReturn : nfas.getOutgoingAfterReturn()) {
            digraph.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(grammarElement, outgoingAfterReturn, true));
        }
        if (nfas.getStatusInternal() != TreeConstState.Status.ENABLED) {
            node.setStyle("dashed");
        }
        if (nfas.isEndState()) {
            node.put((Object)"peripheries", (Object)"2");
        }
        this.setStatusStyle((GraphvizDotBuilder.Props)node, nfas.getStatus());
        node.setLabel(nfas + (String)node.get((Object)"label"));
        return node;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement grammarElement, TreeConstTransition transition, boolean isParent) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge((GraphvizDotBuilder)this, (Object)grammarElement, (Object)transition.getTarget().getGrammarElement());
        if (transition.getPrecedence() > -1) {
            edge.setLabel(String.valueOf(transition.getPrecedence()));
        }
        edge.setStyle("dotted");
        if (isParent) {
            edge.put((Object)"arrowtail", (Object)"odot");
        }
        if (transition.isRuleCall()) {
            edge.put((Object)"arrowhead", (Object)"onormalonormal");
        } else {
            edge.put((Object)"arrowhead", (Object)"onormal");
        }
        this.setStatusStyle((GraphvizDotBuilder.Props)edge, transition.getStatus());
        return edge;
    }

    protected void setStatusStyle(GraphvizDotBuilder.Props properties, TreeConstState.Status status) {
        switch (status) {
            case AMBIGIOUS: {
                properties.put((Object)"color", (Object)"green");
                break;
            }
            case DETOUR_OR_LOOP: {
                properties.put((Object)"color", (Object)"blue");
                break;
            }
            case ORPHAN: {
                properties.put((Object)"color", (Object)"grey");
                break;
            }
            case UNKNOWN: {
                properties.put((Object)"color", (Object)"red");
                break;
            }
        }
    }

    @Override
    protected GraphvizDotBuilder.Node newNode(EObject semanticObject, String label) {
        TreeConstState nfas = this.nfaProvider.getNFA((AbstractElement)semanticObject);
        ArrayList types = Lists.newArrayList();
        for (TypeRef typeRef : nfas.getTypesToCheck()) {
            types.add(typeRef == null ? "null" : typeRef.getClassifier().getName());
        }
        if (semanticObject.eContainer() instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)semanticObject.eContainer();
            String typesAsString = types.isEmpty() ? "" : " [" + Joiner.on((String)",").join((Iterable)types) + "]";
            return new GraphvizDotBuilder.Node((GraphvizDotBuilder)this, (Object)semanticObject, rule.getName() + typesAsString + ":\\n" + label, "record");
        }
        String typesAsString = types.isEmpty() ? "" : "[" + Joiner.on((String)",").join((Iterable)types) + "]\\n";
        return new GraphvizDotBuilder.Node((GraphvizDotBuilder)this, (Object)semanticObject, typesAsString + label);
    }
}

