/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.services;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationTransitionService;

public class ProgressiveMaximizationTransitionService
implements MaximizationTransitionService<Pane, Region> {
    public void maximize(Pane commonRoot, Pane greyPane, Pane containerPane, final Region node, final Runnable finished) {
        Bounds bounds = ProgressiveMaximizationTransitionService.getBoundsInParent((Node)commonRoot, (Node)node);
        Pane pane = new Pane();
        pane.getChildren().add((Object)node);
        node.setTranslateX(bounds.getMinX());
        node.setTranslateY(bounds.getMinY());
        node.setPrefWidth(node.getWidth());
        node.setPrefHeight(node.getHeight());
        containerPane.getChildren().add((Object)pane);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        double duration = 300.0;
        Interpolator interpolator = Interpolator.EASE_BOTH;
        KeyValue kvOpacity = new KeyValue((WritableValue)greyPane.opacityProperty(), (Object)1.0, interpolator);
        KeyFrame kfOpacity = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvOpacity});
        timeline.getKeyFrames().add((Object)kfOpacity);
        KeyValue kv = new KeyValue((WritableValue)node.translateXProperty(), (Object)0.0, interpolator);
        KeyFrame kf = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        KeyValue kvY = new KeyValue((WritableValue)node.translateYProperty(), (Object)0.0, interpolator);
        KeyFrame kfY = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvY});
        timeline.getKeyFrames().add((Object)kfY);
        KeyValue kvYWidth = new KeyValue((WritableValue)node.prefWidthProperty(), (Object)commonRoot.getWidth(), interpolator);
        KeyFrame kfYWidth = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvYWidth});
        timeline.getKeyFrames().add((Object)kfYWidth);
        KeyValue kvYHeight = new KeyValue((WritableValue)node.prefHeightProperty(), (Object)commonRoot.getHeight(), interpolator);
        KeyFrame kfYHeight = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvYHeight});
        timeline.getKeyFrames().add((Object)kfYHeight);
        timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                node.setPrefSize(-1.0, -1.0);
                node.setTranslateX(0.0);
                node.setTranslateY(0.0);
                finished.run();
            }
        });
        timeline.play();
    }

    public void restore(Pane commonRoot, Pane greyPane, Pane containerPane, Pane nodeContainer, final Region node, final Runnable finished) {
        Bounds bounds = ProgressiveMaximizationTransitionService.getBoundsInParent((Node)commonRoot, (Node)nodeContainer);
        Pane pane = new Pane();
        pane.getChildren().add((Object)node);
        node.setPrefSize(node.getWidth(), node.getHeight());
        containerPane.getChildren().add((Object)pane);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        double duration = 300.0;
        Interpolator interpolator = Interpolator.EASE_BOTH;
        KeyValue kvOpacity = new KeyValue((WritableValue)greyPane.opacityProperty(), (Object)0.0, interpolator);
        KeyFrame kfOpacity = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvOpacity});
        timeline.getKeyFrames().add((Object)kfOpacity);
        KeyValue kv = new KeyValue((WritableValue)node.translateXProperty(), (Object)bounds.getMinX(), interpolator);
        KeyFrame kf = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        KeyValue kvY = new KeyValue((WritableValue)node.translateYProperty(), (Object)bounds.getMinY(), interpolator);
        KeyFrame kfY = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvY});
        timeline.getKeyFrames().add((Object)kfY);
        KeyValue kvYWidth = new KeyValue((WritableValue)node.prefWidthProperty(), (Object)bounds.getWidth(), interpolator);
        KeyFrame kfYWidth = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvYWidth});
        timeline.getKeyFrames().add((Object)kfYWidth);
        KeyValue kvYHeight = new KeyValue((WritableValue)node.prefHeightProperty(), (Object)bounds.getHeight(), interpolator);
        KeyFrame kfYHeight = new KeyFrame(Duration.millis((double)duration), new KeyValue[]{kvYHeight});
        timeline.getKeyFrames().add((Object)kfYHeight);
        timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                node.setPrefSize(-1.0, -1.0);
                node.setTranslateX(0.0);
                node.setTranslateY(0.0);
                finished.run();
            }
        });
        timeline.play();
    }

    private static Bounds getBoundsInParent(Node parentNode, Node childNode) {
        Node child = childNode;
        Bounds bounds = child.getLayoutBounds();
        while (child != null && child != parentNode) {
            bounds = child.localToParent(bounds);
            child = child.getParent();
        }
        return bounds;
    }
}

