/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCharDataGenerator;
import org.eclipse.emf.codegen.jet.JETConstantDataGenerator;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETExpressionGenerator;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParseEventListener;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETReader;
import org.eclipse.emf.codegen.jet.JETScriptletGenerator;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETCompiler
implements JETParseEventListener {
    protected static final char[] NULL_CHAR_ARRAY = new char[0];
    protected String[] templateURIPath;
    protected String templateURI;
    protected JETParser parser;
    protected JETSkeleton skeleton;
    protected JETReader reader;
    protected PrintWriter writer;
    protected List<JETGenerator> generators = new ArrayList<JETGenerator>(100);
    protected List<JETConstantDataGenerator> constants = new ArrayList<JETConstantDataGenerator>(100);
    protected Map<char[], JETConstantDataGenerator> constantDictionary = new HashMap<char[], JETConstantDataGenerator>(100, 100.0f);
    protected long constantCount = 0L;
    protected boolean fNoNewLineForScriptlets = true;
    protected boolean fUseStaticFinalConstants = true;
    protected char[] fSavedLine = null;
    protected int sectionDepth = 0;
    protected boolean skipping = false;
    protected Stack<SkipSection> skipSections = new Stack();
    protected static final String CONSTANT_PREFIX = "TEXT_";

    public JETCompiler(String templateURI) throws JETException {
        this(templateURI, "UTF8");
    }

    public JETCompiler(String templateURI, String encoding) throws JETException {
        this(templateURI, JETCompiler.openStream(templateURI), encoding);
    }

    public JETCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        this.templateURI = templateURI;
        this.reader = new JETReader(templateURI, inputStream, encoding);
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
        this(templateURIPath, relativeTemplateURI, "UTF8");
    }

    public JETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        String[] actualTemplateURI = JETCompiler.findLocation(templateURIPath, 0, relativeTemplateURI);
        this.reader = new JETReader(actualTemplateURI[1], relativeTemplateURI, JETCompiler.openStream(actualTemplateURI[0]), encoding);
    }

    public String getResolvedTemplateURI() {
        return this.reader.getFile(0);
    }

    @Override
    public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        block33: {
            if (directive.equals("include")) {
                String fileURI = attributes.get("file");
                if (fileURI != null) {
                    String currentURI = start.getFile();
                    String[] resolvedFileURI = JETCompiler.resolveLocation(this.templateURIPath, currentURI, fileURI);
                    if (resolvedFileURI[0].equals(currentURI)) {
                        String baseURI;
                        boolean loop = true;
                        if (this.templateURIPath != null && (baseURI = start.getBaseURI()) != null) {
                            int i = 0;
                            while (i < this.templateURIPath.length) {
                                if (baseURI.equals(this.templateURIPath[i])) {
                                    resolvedFileURI = JETCompiler.resolveLocation(this.templateURIPath, i + 1, currentURI, fileURI);
                                    loop = false;
                                }
                                ++i;
                            }
                        }
                        if (loop) {
                            return;
                        }
                    }
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(resolvedFileURI[1]));
                        this.reader.stackStream(resolvedFileURI[2], resolvedFileURI[0], bufferedInputStream, null);
                        if ("alternative".equals(attributes.get("fail"))) {
                            this.skipSections.push(new SkipSection(this.sectionDepth + 1, !this.skipping));
                        }
                        if (this.fSavedLine != null) {
                            return;
                        }
                        break block33;
                    }
                    catch (JETException exception) {
                        String failType = attributes.get("fail");
                        if ("alternative".equals(failType)) {
                            this.skipSections.push(new SkipSection(this.sectionDepth + 1, false));
                        } else if (!"silent".equals(failType)) {
                            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.file.cannot.read", new Object[]{resolvedFileURI[1], start.format("jet.mark.file.line.column")}), (Throwable)((Object)exception));
                        }
                        break block33;
                    }
                }
                throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.missing.attribute", new Object[]{"file", start.format("jet.mark.file.line.column")}));
            }
            if (directive.equals("start")) {
                SkipSection skipSection;
                ++this.sectionDepth;
                SkipSection skipSection2 = skipSection = this.skipSections.isEmpty() ? null : this.skipSections.peek();
                if (skipSection == null || skipSection.depth != this.sectionDepth) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.section.noinclude", new Object[]{start.format("jet.mark.file.line.column")}));
                }
                if (skipSection.skip) {
                    this.skipping = true;
                }
            } else if (directive.equals("end")) {
                if (this.sectionDepth == 0) {
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unmatched.directive", new Object[]{"start", "end", start.format("jet.mark.file.line.column")}));
                }
                --this.sectionDepth;
                if (this.skipSections.pop().skip) {
                    this.skipping = false;
                }
            } else if (directive.equals("jet") && this.skeleton == null) {
                this.skeleton = new JETSkeleton();
                String skeletonURI = attributes.get("skeleton");
                if (skeletonURI != null) {
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(JETCompiler.openStream(JETCompiler.resolveLocation(this.templateURIPath, this.templateURI, skeletonURI)[1]));
                        byte[] input = new byte[bufferedInputStream.available()];
                        bufferedInputStream.read(input);
                        bufferedInputStream.close();
                        String skeletonEncoding = attributes.get("skeletonEncoding");
                        this.skeleton.setCompilationUnitContents(skeletonEncoding == null ? new String(input) : new String(input, skeletonEncoding));
                    }
                    catch (IOException exception) {
                        throw new JETException(exception);
                    }
                }
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (entry.getKey().equals("skeleton")) continue;
                    if (entry.getKey().equals("package")) {
                        this.skeleton.setPackageName(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("imports")) {
                        this.skeleton.addImports(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("class")) {
                        this.skeleton.setClassName(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("nlString")) {
                        this.skeleton.setNLString(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("startTag")) {
                        this.parser.setStartTag(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("endTag")) {
                        this.parser.setEndTag(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("version")) continue;
                    throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.bad.attribute", new Object[]{entry.getKey(), start.format("jet.mark.file.line.column")}));
                }
                this.handleNewSkeleton();
            }
        }
        this.fSavedLine = null;
    }

    protected void handleNewSkeleton() {
    }

    @Override
    public void handleExpression(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        if (this.skipping) {
            return;
        }
        JETExpressionGenerator gen = new JETExpressionGenerator(this.reader.getChars(start, stop));
        this.addGenerator(gen);
    }

    @Override
    public void handleScriptlet(JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        if (this.skipping) {
            return;
        }
        this.fSavedLine = null;
        JETScriptletGenerator gen = new JETScriptletGenerator(this.reader.getChars(start, stop));
        this.addGenerator(gen);
    }

    @Override
    public void handleCharData(char[] chars) throws JETException {
        if (this.skipping) {
            return;
        }
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
            this.fSavedLine = null;
        }
        if (this.fNoNewLineForScriptlets) {
            char[] strippedChars = this.stripLastNewLineWithBlanks(chars);
            if (strippedChars.length > 0) {
                this.addCharDataGenerator(strippedChars);
            }
        } else {
            this.addCharDataGenerator(chars);
        }
    }

    public void addGenerator(JETGenerator gen) throws JETException {
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
            this.fSavedLine = null;
        }
        this.generators.add(gen);
    }

    public void addCharDataGenerator(char[] chars) throws JETException {
        block11: {
            if (chars.length <= 500) break block11;
            int nl = 0;
            int lf = 0;
            int start = 0;
            int i = 0;
            while (i < chars.length) {
                block12: {
                    switch (chars[i]) {
                        case '\n': {
                            ++nl;
                            break;
                        }
                        case '\r': {
                            ++lf;
                            break;
                        }
                        default: {
                            break block12;
                        }
                    }
                    if (lf > 400 || nl > 400) {
                        ++i;
                        block8: while (i < chars.length) {
                            switch (chars[i]) {
                                case '\n': 
                                case '\r': {
                                    break;
                                }
                                default: {
                                    int size = i - start;
                                    char[] block = new char[size];
                                    System.arraycopy(chars, start, block, 0, size);
                                    this.doAddCharDataGenerator(block);
                                    start = i;
                                    nl = 0;
                                    lf = 0;
                                    break block8;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++i;
            }
            if (start != 0) {
                int size = chars.length - start;
                char[] block = new char[size];
                System.arraycopy(chars, start, block, 0, size);
                this.doAddCharDataGenerator(block);
                return;
            }
        }
        this.doAddCharDataGenerator(chars);
    }

    public void doAddCharDataGenerator(char[] chars) throws JETException {
        if (this.fUseStaticFinalConstants) {
            JETConstantDataGenerator gen = this.constantDictionary.get(chars);
            if (gen == null) {
                if (this.constantCount == 0L) {
                    chars = this.stripFirstNewLineWithBlanks(chars);
                }
                ++this.constantCount;
                String label = CONSTANT_PREFIX + this.constantCount;
                gen = new JETConstantDataGenerator(chars, label);
                this.constantDictionary.put(chars, gen);
                this.constants.add(gen);
            }
            this.generators.add(gen);
        } else {
            this.generators.add(new JETCharDataGenerator(chars));
        }
    }

    protected char[] stripFirstNewLineWithBlanks(char[] chars) {
        if (chars.length >= 2 && (chars[0] == '\n' && chars[1] == '\r' || chars[0] == '\r' && chars[1] == '\n')) {
            chars = new String(chars, 2, chars.length - 2).toCharArray();
        } else if (chars.length >= 1 && (chars[0] == '\n' || chars[0] == '\r')) {
            chars = new String(chars, 1, chars.length - 1).toCharArray();
        }
        return chars;
    }

    protected char[] stripLastNewLineWithBlanks(char[] chars) {
        int i = chars.length - 1;
        while (i > 0 && chars[i] == ' ') {
            --i;
        }
        if (chars[i] == '\n') {
            if (i > 0 && chars[i - 1] == '\r') {
                --i;
            }
            this.fSavedLine = new String(chars, i, chars.length - i).toCharArray();
            if (i == 0) {
                return NULL_CHAR_ARRAY;
            }
            chars = new String(chars, 0, i).toCharArray();
            return chars;
        }
        return chars;
    }

    @Override
    public void beginPageProcessing() {
    }

    @Override
    public void endPageProcessing() throws JETException {
        if (this.sectionDepth > 0) {
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.unmatched.directive", new Object[]{"end", "start", this.reader.mark().format("jet.mark.file.line.column")}));
        }
        if (this.skeleton == null) {
            throw new JETException(CodeGenPlugin.getPlugin().getString("jet.error.missing.jet.directive", new Object[]{this.reader.mark().format("jet.mark.file.line.column")}));
        }
        if (this.fSavedLine != null) {
            this.addCharDataGenerator(this.fSavedLine);
        }
        ArrayList<String> generatedConstants = new ArrayList<String>(this.constants.size());
        for (JETConstantDataGenerator jetConstantDataGenerator : this.constants) {
            generatedConstants.add(jetConstantDataGenerator.generateConstant());
        }
        this.skeleton.setConstants(generatedConstants);
        ArrayList<String> generatedBody = new ArrayList<String>(this.generators.size());
        for (JETGenerator jetGenerator : this.generators) {
            generatedBody.add(jetGenerator.generate());
        }
        this.skeleton.setBody(generatedBody);
        this.writer.print(this.skeleton.getCompilationUnitContents());
    }

    public void parse() throws JETException {
        JETParser.Directive directive = new JETParser.Directive();
        directive.getDirectives().add("jet");
        directive.getDirectives().add("include");
        directive.getDirectives().add("start");
        directive.getDirectives().add("end");
        JETCoreElement[] coreElements = new JETCoreElement[]{directive, new JETParser.QuoteEscape(), new JETParser.Expression(), new JETParser.Scriptlet()};
        Class[] accept = new Class[]{JETParser.Directive.class, JETParser.QuoteEscape.class, JETParser.Expression.class, JETParser.Scriptlet.class};
        this.parse(coreElements, accept);
    }

    protected void parse(JETCoreElement[] coreElements, Class<?>[] accept) throws JETException {
        this.parser = new JETParser(this.reader, this, coreElements);
        this.beginPageProcessing();
        this.parser.parse(null, accept);
    }

    public void generate(OutputStream oStream) throws JETException {
        this.writer = new PrintWriter(oStream);
        this.endPageProcessing();
        this.writer.close();
    }

    public void generate(Writer writer) throws JETException {
        this.writer = new PrintWriter(writer);
        this.endPageProcessing();
        this.writer.close();
    }

    public JETSkeleton getSkeleton() {
        return this.skeleton;
    }

    protected static String[] resolveLocation(String[] templateURIPath, String baseLocationURI, String locationURI) {
        return JETCompiler.resolveLocation(templateURIPath, 0, baseLocationURI, locationURI);
    }

    protected static String[] resolveLocation(String[] templateURIPath, int start, String baseLocationURI, String locationURI) {
        String[] stringArray = new String[3];
        stringArray[0] = locationURI;
        stringArray[1] = locationURI;
        String[] result = stringArray;
        URI uri = URI.createURI((String)locationURI);
        try {
            new URL(locationURI);
            uri = CommonPlugin.resolve((URI)uri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uri.isRelative() && uri.hasRelativePath()) {
            String resolvedLocation = "";
            int index = baseLocationURI.lastIndexOf("/");
            if (index != -1) {
                resolvedLocation = baseLocationURI.substring(0, index + 1);
            }
            result[0] = resolvedLocation = String.valueOf(resolvedLocation) + uri;
            if (templateURIPath != null) {
                String[] location = JETCompiler.findLocation(templateURIPath, start, resolvedLocation);
                resolvedLocation = location[0];
                result[2] = location[1];
            }
            if (resolvedLocation != null) {
                result[1] = resolvedLocation;
            }
        }
        return result;
    }

    public static String[] findLocation(String[] locationURIPath, int start, String relativeLocationURI) {
        String[] result = new String[2];
        int i = start;
        while (i < locationURIPath.length) {
            result[0] = locationURIPath[i];
            result[1] = locationURIPath[i];
            if (result[0] != null) {
                try {
                    if (!result[0].endsWith("/")) {
                        result[0] = String.valueOf(result[0]) + "/";
                    }
                    result[0] = String.valueOf(result[0]) + relativeLocationURI;
                    InputStream inputStream = JETCompiler.openStream(result[0]);
                    inputStream.close();
                    break;
                }
                catch (JETException exception) {
                    result[0] = null;
                }
                catch (IOException exception) {
                    result[0] = null;
                }
            }
            ++i;
        }
        return result;
    }

    public static String find(String[] locationURIPath, String relativeLocationURI) {
        return JETCompiler.findLocation(locationURIPath, 0, relativeLocationURI)[0];
    }

    public static InputStream openStream(String locationURI) throws JETException {
        try {
            URL url;
            URI uri = URI.createURI((String)locationURI);
            try {
                uri = CommonPlugin.resolve((URI)uri);
                url = new URL(uri.toString());
            }
            catch (MalformedURLException exception) {
                url = new URL("file:" + locationURI);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            return bufferedInputStream;
        }
        catch (IOException exception) {
            throw new JETException(exception.getLocalizedMessage(), exception);
        }
    }

    static class SkipSection {
        int depth;
        boolean skip;

        SkipSection(int depth, boolean skip) {
            this.depth = depth;
            this.skip = skip;
        }
    }
}

