/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCompositePart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseCompositePartRenderer<N>
extends BaseRenderer<MCompositePart, WCompositePart<N>> {
    @Inject
    RendererFactory factory;

    @PostConstruct
    void init(@NonNull IEventBroker eventBroker) {
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/localizedLabel/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/localizedTooltip/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Part/description/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/basic/Part/localizedDescription/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*");
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MCompositePart parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MCompositePart && BaseCompositePartRenderer.this == (parent = (MCompositePart)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseCompositePartRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseCompositePartRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MCompositePart parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MCompositePart && BaseCompositePartRenderer.this == (parent = (MCompositePart)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseCompositePartRenderer.this.handleSelectedElement(parent, (MPartSashContainerElement)oldValue, (MPartSashContainerElement)newValue);
                }
            }
        });
        EventProcessor.attachVisibleProcessor(eventBroker, this);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/containerData/*", new EventHandler(){

            public void handleEvent(Event event) {
                MElementContainer parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj != null && changedObj.getParent() != null && changedObj.getParent().getRenderer() == BaseCompositePartRenderer.this && (parent = changedObj.getParent()) != null && !BaseCompositePartRenderer.this.inUIModification((MUIElement)parent)) {
                    @Nullable WCompositePart widget = (WCompositePart)BaseCompositePartRenderer.this.getWidget((MUIElement)((MCompositePart)parent));
                    if (widget != null) {
                        widget.updateLayout();
                    } else {
                        BaseCompositePartRenderer.this.getLogger().error("Could not find widget for '" + parent + "'");
                    }
                }
            }
        });
    }

    @Override
    public void doProcessContent(MCompositePart element) {
        WCompositePart sash = (WCompositePart)this.getWidget((MUIElement)element);
        if (sash == null) {
            this.getLogger().error("Could not find widget for '" + element + "'");
            return;
        }
        Class<?> cl = sash.getWidget().getClass();
        do {
            element.getContext().set(cl.getName(), sash.getWidget());
        } while ((cl = cl.getSuperclass()) != Object.class);
        if (element.getContributionURI() != null) {
            IContributionFactory contributionFactory = (IContributionFactory)element.getContext().get(IContributionFactory.class);
            Object newPart = contributionFactory.create(element.getContributionURI(), element.getContext());
            element.setObject(newPart);
        }
        ArrayList<WLayoutedWidget<MPartSashContainerElement>> list = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        for (MPartSashContainerElement e : element.getChildren()) {
            WLayoutedWidget widget;
            if (!e.isToBeRendered() || (widget = (WLayoutedWidget)this.engineCreateWidget(e)) == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            list.add(widget);
        }
        MToolBar mToolBar = element.getToolbar();
        if (mToolBar != null) {
            WToolBar toolbar = (WToolBar)this.engineCreateWidget(mToolBar);
            sash.setToolbar(toolbar);
        }
        for (MMenu m : element.getMenus()) {
            if (!m.getTags().contains("ViewMenu")) continue;
            WMenu menu = (WMenu)this.engineCreateWidget(m);
            sash.setMenu(menu);
            break;
        }
        sash.addItems(list);
    }

    public void childRendered(MCompositePart parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WCompositePart sash = (WCompositePart)this.getWidget((MUIElement)parentElement);
        if (sash == null) {
            this.getLogger().error("Could not find widget for '" + parentElement + "'");
            return;
        }
        WLayoutedWidget w = (WLayoutedWidget)element.getWidget();
        if (w != null) {
            List<@NonNull WLayoutedWidget<MPartSashContainerElement>> l = Collections.singletonList(w);
            sash.addItems(idx, l);
        } else {
            this.logger.error("The widget for element '" + element + "' should not be null");
        }
    }

    public void hideChild(MCompositePart container, MUIElement changedObj) {
        WCompositePart sash = (WCompositePart)this.getWidget((MUIElement)container);
        if (sash == null) {
            return;
        }
        WLayoutedWidget widget = (WLayoutedWidget)changedObj.getWidget();
        if (widget != null) {
            sash.removeItem(widget);
        }
        if (container.getSelectedElement() == changedObj && widget != null && widget.getWidgetState() != WWidget.WidgetState.IN_TEAR_DOWN) {
            container.setSelectedElement(null);
        }
    }

    void handleChildrenAddition(@NonNull MCompositePart parent, Collection<MPartSashContainerElement> elements) {
        for (MUIElement mUIElement : elements) {
            if (!mUIElement.isToBeRendered()) continue;
            if (mUIElement.getWidget() == null) {
                this.engineCreateWidget(mUIElement);
                continue;
            }
            this.childRendered(parent, mUIElement);
            this.fixContextHierarchy(elements);
        }
    }

    void handleChildrenRemove(@NonNull MCompositePart parent, Collection<MPartSashContainerElement> elements) {
        for (MPartSashContainerElement element : elements) {
            if (!element.isToBeRendered() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
        this.checkSelectedElement((MUIElement)parent);
    }

    void handleSelectedElement(MCompositePart parent, MPartSashContainerElement oldElement, MPartSashContainerElement newElement) {
    }
}

