/**
 * Copyright (c) 2015 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.base.Objects;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Generator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.adapter.FragmentAdapter;
import org.eclipse.xtext.generator.parser.antlr.AntlrGrammarComparator;
import org.eclipse.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.XtextAntlrUiGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.ex.common.AntlrFragmentHelper;
import org.eclipse.xtext.generator.parser.antlr.ex.rt.AntlrGeneratorFragment;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.FlattenedGrammarAccess;
import org.eclipse.xtext.xtext.RuleFilter;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.IBundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.CombinedGrammarMarker;
import org.eclipse.xtext.xtext.generator.parser.antlr.ContentAssistGrammarNaming;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;

/**
 * Compares the ANTLR grammar generated by {@link
 * org.eclipse.xtext.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment2
 * XtextAntlrGeneratorFragment2} with that of {@link XtextAntlrGeneratorFragment}
 * by running its grammar generation in a temporary folder and calling {@link
 * GrammarComparator} to compare them.
 * 
 * @author Christian Schneider - Initial contribution and API
 * @noreference
 */
@Log
@SuppressWarnings("all")
public class XtextAntlrGeneratorComparisonFragment extends FragmentAdapter {
  public static class ErrorHandler implements AntlrGrammarComparator.IErrorHandler {
    private File tmpFolder;
    
    public ErrorHandler(final File tmpFolder) {
      this.tmpFolder = tmpFolder;
    }
    
    @Override
    public void handleInvalidGeneratedGrammarFile(final AntlrGrammarComparator.ErrorContext context) {
      XtextAntlrGeneratorComparisonFragment.deleteDir(this.tmpFolder);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Noticed an unexpectect character sequence in reference grammar after token ");
      AntlrGrammarComparator.MatchState _testedGrammar = context.getTestedGrammar();
      String _previousToken = _testedGrammar.getPreviousToken();
      _builder.append(_previousToken, "");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("and before token ");
      AntlrGrammarComparator.MatchState _testedGrammar_1 = context.getTestedGrammar();
      String _currentToken = _testedGrammar_1.getCurrentToken();
      _builder.append(_currentToken, "\t");
      _builder.append(" in line ");
      AntlrGrammarComparator.MatchState _testedGrammar_2 = context.getTestedGrammar();
      int _lineNumber = _testedGrammar_2.getLineNumber();
      _builder.append(_lineNumber, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("in file ");
      AntlrGrammarComparator.MatchState _testedGrammar_3 = context.getTestedGrammar();
      String _absoluteFileName = _testedGrammar_3.getAbsoluteFileName();
      _builder.append(_absoluteFileName, "\t");
      _builder.append(".");
      throw new RuntimeException(_builder.toString());
    }
    
    @Override
    public void handleInvalidReferenceGrammarFile(final AntlrGrammarComparator.ErrorContext context) {
      AntlrGrammarComparator.MatchState _referenceGrammar = context.getReferenceGrammar();
      String _absoluteFileName = _referenceGrammar.getAbsoluteFileName();
      AntlrGrammarComparator.MatchState _testedGrammar = context.getTestedGrammar();
      String _absoluteFileName_1 = _testedGrammar.getAbsoluteFileName();
      XtextAntlrGeneratorComparisonFragment.copyFile(_absoluteFileName, _absoluteFileName_1);
      XtextAntlrGeneratorComparisonFragment.deleteDir(this.tmpFolder);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Noticed an unexpectect character sequence in reference grammar after token ");
      AntlrGrammarComparator.MatchState _referenceGrammar_1 = context.getReferenceGrammar();
      String _previousToken = _referenceGrammar_1.getPreviousToken();
      _builder.append(_previousToken, "");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("and before token ");
      AntlrGrammarComparator.MatchState _referenceGrammar_2 = context.getReferenceGrammar();
      String _currentToken = _referenceGrammar_2.getCurrentToken();
      _builder.append(_currentToken, "\t");
      _builder.append(" in line ");
      AntlrGrammarComparator.MatchState _referenceGrammar_3 = context.getReferenceGrammar();
      int _lineNumber = _referenceGrammar_3.getLineNumber();
      _builder.append(_lineNumber, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("in file ");
      AntlrGrammarComparator.MatchState _referenceGrammar_4 = context.getReferenceGrammar();
      String _absoluteFileName_2 = _referenceGrammar_4.getAbsoluteFileName();
      _builder.append(_absoluteFileName_2, "\t");
      _builder.append(".");
      throw new RuntimeException(_builder.toString());
    }
    
    @Override
    public void handleMismatch(final String match, final String matchReference, final AntlrGrammarComparator.ErrorContext context) {
      AntlrGrammarComparator.MatchState _referenceGrammar = context.getReferenceGrammar();
      String _absoluteFileName = _referenceGrammar.getAbsoluteFileName();
      AntlrGrammarComparator.MatchState _testedGrammar = context.getTestedGrammar();
      String _absoluteFileName_1 = _testedGrammar.getAbsoluteFileName();
      XtextAntlrGeneratorComparisonFragment.copyFile(_absoluteFileName, _absoluteFileName_1);
      XtextAntlrGeneratorComparisonFragment.deleteDir(this.tmpFolder);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Generated grammar ");
      AntlrGrammarComparator.MatchState _testedGrammar_1 = context.getTestedGrammar();
      String _absoluteFileName_2 = _testedGrammar_1.getAbsoluteFileName();
      _builder.append(_absoluteFileName_2, "");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("differs at token ");
      _builder.append(match, "\t");
      _builder.append(" (line ");
      AntlrGrammarComparator.MatchState _testedGrammar_2 = context.getTestedGrammar();
      int _lineNumber = _testedGrammar_2.getLineNumber();
      _builder.append(_lineNumber, "\t");
      _builder.append("), expected token ");
      _builder.append(matchReference, "\t");
      _builder.append(" (line ");
      AntlrGrammarComparator.MatchState _referenceGrammar_1 = context.getReferenceGrammar();
      int _lineNumber_1 = _referenceGrammar_1.getLineNumber();
      _builder.append(_lineNumber_1, "\t");
      _builder.append(").");
      throw new RuntimeException(_builder.toString());
    }
  }
  
  private static class AntlrFragmentHelperEx extends AntlrFragmentHelper {
    private Naming oldNaming;
    
    private GrammarNaming prodNaming;
    
    private ContentAssistGrammarNaming caNaming;
    
    public AntlrFragmentHelperEx(final Naming oldNaming, final GrammarNaming prodNaming, final ContentAssistGrammarNaming caNaming) {
      super(oldNaming);
      this.oldNaming = oldNaming;
      this.prodNaming = prodNaming;
      this.caNaming = caNaming;
    }
    
    @Override
    public String getLexerGrammarFileName(final Grammar g) {
      AntlrGrammar _lexerGrammar = this.prodNaming.getLexerGrammar(g);
      return _lexerGrammar.getName();
    }
    
    @Override
    public String getContentAssistLexerGrammarFileName(final Grammar g) {
      AntlrGrammar _lexerGrammar = this.caNaming.getLexerGrammar(g);
      return _lexerGrammar.getName();
    }
  }
  
  private final static String ENCODING = "ISO-8859-1";
  
  @Inject
  @Extension
  private GrammarNaming productionNaming;
  
  @Inject
  private ContentAssistGrammarNaming contentAssistNaming;
  
  @Inject
  private AntlrGrammarComparator comparator;
  
  @Accessors
  private AntlrOptions options;
  
  @Accessors
  private boolean partialParsing;
  
  @Accessors
  private boolean skipContentAssistGrammarComparison = false;
  
  private List<String> advices = CollectionLiterals.<String>newArrayList();
  
  public void addRegisterAdvice(final String advice) {
    this.advices.add(advice);
  }
  
  /**
   * Deactivate the super class' initialization check.
   */
  @Override
  public void checkConfiguration(final Issues issues) {
  }
  
  /**
   * Tweaks the generation of the {@link Generator#SRC_GEN Generator.SRC_GEN} outlet
   * and injects the {@link #getTmpPath()}.
   */
  @Override
  protected Outlet createOutlet(final boolean append, final String encoding, final String name, final boolean overwrite, final String path) {
    Outlet _xifexpression = null;
    if (((Objects.equal(name, Generator.SRC_GEN) || Objects.equal(name, Generator.SRC_GEN_IDE)) || Objects.equal(name, Generator.SRC_GEN_UI))) {
      File _tmpFolder = this.getTmpFolder();
      String _absolutePath = _tmpFolder.getAbsolutePath();
      _xifexpression = super.createOutlet(append, encoding, name, overwrite, _absolutePath);
    } else {
      _xifexpression = super.createOutlet(append, encoding, name, overwrite, path);
    }
    return _xifexpression;
  }
  
  @Override
  public void generate() {
    Naming _naming = this.getNaming();
    boolean _tripleEquals = (_naming == null);
    if (_tripleEquals) {
      Naming _createNaming = this.createNaming();
      this.setNaming(_createNaming);
    }
    if ((this.options == null)) {
      AntlrOptions _antlrOptions = new AntlrOptions();
      this.options = _antlrOptions;
    }
    File _tmpFolder = this.getTmpFolder();
    final XtextAntlrGeneratorComparisonFragment.ErrorHandler errorHandler = new XtextAntlrGeneratorComparisonFragment.ErrorHandler(_tmpFolder);
    IXtextProjectConfig _projectConfig = this.getProjectConfig();
    IRuntimeProjectConfig _runtime = _projectConfig.getRuntime();
    IXtextGeneratorFileSystemAccess _srcGen = null;
    if (_runtime!=null) {
      _srcGen=_runtime.getSrcGen();
    }
    boolean _notEquals = (!Objects.equal(_srcGen, null));
    if (_notEquals) {
      IXtextProjectConfig _projectConfig_1 = this.getProjectConfig();
      IRuntimeProjectConfig _runtime_1 = _projectConfig_1.getRuntime();
      IXtextGeneratorFileSystemAccess _srcGen_1 = _runtime_1.getSrcGen();
      this.loadAndCompareGrammars(_srcGen_1, Generator.SRC_GEN, errorHandler);
    }
    boolean _and = false;
    if (!(!this.skipContentAssistGrammarComparison)) {
      _and = false;
    } else {
      IXtextProjectConfig _projectConfig_2 = this.getProjectConfig();
      IBundleProjectConfig _genericIde = _projectConfig_2.getGenericIde();
      IXtextGeneratorFileSystemAccess _srcGen_2 = null;
      if (_genericIde!=null) {
        _srcGen_2=_genericIde.getSrcGen();
      }
      boolean _notEquals_1 = (!Objects.equal(_srcGen_2, null));
      _and = _notEquals_1;
    }
    if (_and) {
      IXtextProjectConfig _projectConfig_3 = this.getProjectConfig();
      IBundleProjectConfig _genericIde_1 = _projectConfig_3.getGenericIde();
      IXtextGeneratorFileSystemAccess _srcGen_3 = _genericIde_1.getSrcGen();
      this.loadAndCompareGrammars(_srcGen_3, Generator.SRC_GEN_IDE, errorHandler);
    }
    File _tmpFolder_1 = this.getTmpFolder();
    XtextAntlrGeneratorComparisonFragment.deleteDir(_tmpFolder_1);
  }
  
  protected void loadAndCompareGrammars(final IFileSystemAccess2 fsa, final String outlet, final XtextAntlrGeneratorComparisonFragment.ErrorHandler errorHandler) {
    try {
      final StopWatch stopWatch = new StopWatch();
      stopWatch.reset();
      this.performXpandBasedGeneration(outlet);
      String parserGrammarFileName = null;
      String lexerGrammarFileName = null;
      String type = null;
      boolean _equals = Objects.equal(outlet, Generator.SRC_GEN);
      if (_equals) {
        Grammar _grammar = this.getGrammar();
        AntlrGrammar _lexerGrammar = this.productionNaming.getLexerGrammar(_grammar);
        String _grammarFileName = _lexerGrammar.getGrammarFileName();
        lexerGrammarFileName = _grammarFileName;
        Grammar _grammar_1 = this.getGrammar();
        AntlrGrammar _parserGrammar = this.productionNaming.getParserGrammar(_grammar_1);
        String _grammarFileName_1 = _parserGrammar.getGrammarFileName();
        parserGrammarFileName = _grammarFileName_1;
        type = "runtime";
      } else {
        boolean _equals_1 = Objects.equal(outlet, Generator.SRC_GEN_IDE);
        if (_equals_1) {
          Grammar _grammar_2 = this.getGrammar();
          AntlrGrammar _lexerGrammar_1 = this.contentAssistNaming.getLexerGrammar(_grammar_2);
          String _grammarFileName_2 = _lexerGrammar_1.getGrammarFileName();
          lexerGrammarFileName = _grammarFileName_2;
          Grammar _grammar_3 = this.getGrammar();
          AntlrGrammar _parserGrammar_1 = this.contentAssistNaming.getParserGrammar(_grammar_3);
          String _grammarFileName_3 = _parserGrammar_1.getGrammarFileName();
          parserGrammarFileName = _grammarFileName_3;
          type = "content assist";
        } else {
          throw new RuntimeException("Unexpected value of parameter \'outlet\'");
        }
      }
      StringConcatenation _builder = new StringConcatenation();
      File _tmpFolder = this.getTmpFolder();
      String _absolutePath = _tmpFolder.getAbsolutePath();
      _builder.append(_absolutePath, "");
      _builder.append("/");
      _builder.append(lexerGrammarFileName, "");
      final String absoluteLexerGrammarFileNameReference = _builder.toString();
      StringConcatenation _builder_1 = new StringConcatenation();
      File _tmpFolder_1 = this.getTmpFolder();
      String _absolutePath_1 = _tmpFolder_1.getAbsolutePath();
      _builder_1.append(_absolutePath_1, "");
      _builder_1.append("/");
      _builder_1.append(parserGrammarFileName, "");
      final String absoluteParserGrammarFileNameReference = _builder_1.toString();
      AntlrGrammarComparator.ErrorContext _xifexpression = null;
      Grammar _grammar_4 = this.getGrammar();
      boolean _isCombinedGrammar = this.productionNaming.isCombinedGrammar(_grammar_4);
      boolean _not = (!_isCombinedGrammar);
      if (_not) {
        AntlrGrammarComparator.ErrorContext _xblockexpression = null;
        {
          final CharSequence lexerGrammarFile = fsa.readTextFile(lexerGrammarFileName);
          File _file = new File(absoluteLexerGrammarFileNameReference);
          Charset _forName = Charset.forName(XtextAntlrGeneratorComparisonFragment.ENCODING);
          final String lexerGrammarFileReference = Files.toString(_file, _forName);
          StringConcatenation _builder_2 = new StringConcatenation();
          String _path = this.getPath(fsa);
          _builder_2.append(_path, "");
          _builder_2.append("/");
          _builder_2.append(lexerGrammarFileName, "");
          _xblockexpression = this.comparator.compareGrammars(lexerGrammarFile, lexerGrammarFileReference, _builder_2.toString(), absoluteLexerGrammarFileNameReference, errorHandler);
        }
        _xifexpression = _xblockexpression;
      }
      final AntlrGrammarComparator.ErrorContext resultLexer = _xifexpression;
      boolean _notEquals = (!Objects.equal(resultLexer, null));
      if (_notEquals) {
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Generated ");
        _builder_2.append(type, "");
        _builder_2.append(" lexer grammar of ");
        AntlrGrammarComparator.MatchState _testedGrammar = resultLexer.getTestedGrammar();
        int _lineNumber = _testedGrammar.getLineNumber();
        _builder_2.append(_lineNumber, "");
        _builder_2.append(" lines matches expected one of ");
        AntlrGrammarComparator.MatchState _referenceGrammar = resultLexer.getReferenceGrammar();
        int _lineNumber_1 = _referenceGrammar.getLineNumber();
        _builder_2.append(_lineNumber_1, "");
        _builder_2.append(".");
        XtextAntlrGeneratorComparisonFragment.LOG.info(_builder_2);
      }
      final CharSequence grammarFile = fsa.readTextFile(parserGrammarFileName);
      File _file = new File(absoluteParserGrammarFileNameReference);
      Charset _forName = Charset.forName(XtextAntlrGeneratorComparisonFragment.ENCODING);
      final String grammarFileReference = Files.toString(_file, _forName);
      StringConcatenation _builder_3 = new StringConcatenation();
      String _path = this.getPath(fsa);
      _builder_3.append(_path, "");
      _builder_3.append("/");
      _builder_3.append(parserGrammarFileName, "");
      final AntlrGrammarComparator.ErrorContext result = this.comparator.compareGrammars(grammarFile, grammarFileReference, _builder_3.toString(), absoluteParserGrammarFileNameReference, errorHandler);
      StringConcatenation _builder_4 = new StringConcatenation();
      _builder_4.append("Generated ");
      _builder_4.append(type, "");
      _builder_4.append(" parser grammar of ");
      AntlrGrammarComparator.MatchState _testedGrammar_1 = result.getTestedGrammar();
      int _lineNumber_2 = _testedGrammar_1.getLineNumber();
      _builder_4.append(_lineNumber_2, "");
      _builder_4.append(" lines matches expected one of ");
      AntlrGrammarComparator.MatchState _referenceGrammar_1 = result.getReferenceGrammar();
      int _lineNumber_3 = _referenceGrammar_1.getLineNumber();
      _builder_4.append(_lineNumber_3, "");
      _builder_4.append(" (");
      long _reset = stopWatch.reset();
      _builder_4.append(_reset, "");
      _builder_4.append(" ms).");
      XtextAntlrGeneratorComparisonFragment.LOG.info(_builder_4);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected void performXpandBasedGeneration(final String outlet) {
    final RuleFilter filter = new RuleFilter();
    boolean _isSkipUnusedRules = this.options.isSkipUnusedRules();
    filter.setDiscardUnreachableRules(_isSkipUnusedRules);
    Grammar _grammar = this.getGrammar();
    final RuleNames ruleNames = RuleNames.getRuleNames(_grammar, true);
    FlattenedGrammarAccess _flattenedGrammarAccess = new FlattenedGrammarAccess(ruleNames, filter);
    final Grammar flattened = _flattenedGrammarAccess.getFlattenedGrammar();
    XpandExecutionContext _createExecutionContext = this.createExecutionContext();
    final XpandExecutionContextImpl context = ((XpandExecutionContextImpl) _createExecutionContext);
    final Procedure1<String> _function = new Procedure1<String>() {
      @Override
      public void apply(final String it) {
        context.registerAdvices(it);
      }
    };
    IterableExtensions.<String>forEach(this.advices, _function);
    Grammar _grammar_1 = this.getGrammar();
    final boolean combined = this.productionNaming.isCombinedGrammar(_grammar_1);
    XtextAntlrGeneratorComparisonFragment.AntlrFragmentHelperEx _xifexpression = null;
    if ((!combined)) {
      Naming _naming = this.getNaming();
      _xifexpression = new XtextAntlrGeneratorComparisonFragment.AntlrFragmentHelperEx(_naming, this.productionNaming, this.contentAssistNaming);
    }
    final XtextAntlrGeneratorComparisonFragment.AntlrFragmentHelperEx helper = _xifexpression;
    String template = null;
    Object[] params = null;
    CombinedGrammarMarker _combinedGrammarMarker = new CombinedGrammarMarker(combined);
    _combinedGrammarMarker.attachToEmfObject(flattened);
    if ((Objects.equal(outlet, Generator.SRC_GEN) && (!Objects.equal(context.getOutput().getOutlet(Generator.SRC_GEN), null)))) {
      if (combined) {
        String _name = XtextAntlrGeneratorFragment.class.getName();
        template = _name;
        params = new Object[] { this.options };
      } else {
        String _name_1 = AntlrGeneratorFragment.class.getName();
        template = _name_1;
        params = new Object[] { this.options, helper };
      }
      XpandFacade _create = XpandFacade.create(context);
      String _replaceAll = template.replaceAll("\\.", "::");
      String _plus = (_replaceAll + "::generate");
      final Object[] _converted_params = (Object[])params;
      _create.evaluate2(_plus, flattened, ((List<Object>)Conversions.doWrapArray(_converted_params)));
    } else {
      if ((Objects.equal(outlet, Generator.SRC_GEN_IDE) && (!Objects.equal(context.getOutput().getOutlet(Generator.SRC_GEN_IDE), null)))) {
        if (combined) {
          String _name_2 = XtextAntlrUiGeneratorFragment.class.getName();
          template = _name_2;
          Naming _naming_1 = this.getNaming();
          boolean _hasIde = _naming_1.hasIde();
          params = new Object[] { this.options, Boolean.valueOf(this.partialParsing), Boolean.valueOf(_hasIde) };
        } else {
          String _name_3 = ContentAssistParserGeneratorFragment.class.getName();
          template = _name_3;
          boolean _booleanValue = Boolean.valueOf(this.partialParsing).booleanValue();
          Naming _naming_2 = this.getNaming();
          boolean _hasIde_1 = _naming_2.hasIde();
          boolean _booleanValue_1 = Boolean.valueOf(_hasIde_1).booleanValue();
          params = new Object[] { this.options, helper, Boolean.valueOf(_booleanValue), Boolean.valueOf(_booleanValue_1) };
        }
        XpandFacade _create_1 = XpandFacade.create(context);
        String _replaceAll_1 = template.replaceAll("\\.", "::");
        String _plus_1 = (_replaceAll_1 + "::generate");
        final Object[] _converted_params_1 = (Object[])params;
        _create_1.evaluate2(_plus_1, flattened, ((List<Object>)Conversions.doWrapArray(_converted_params_1)));
      }
    }
  }
  
  /**
   * offers a singleton temporary folder
   */
  private File getTmpFolder() {
    final ArrayList<?> _cacheKey = CollectionLiterals.newArrayList();
    final File _result;
    synchronized (_createCache_getTmpFolder) {
      if (_createCache_getTmpFolder.containsKey(_cacheKey)) {
        return _createCache_getTmpFolder.get(_cacheKey);
      }
      File _createTempDir = Files.createTempDir();
      _result = _createTempDir;
      _createCache_getTmpFolder.put(_cacheKey, _result);
    }
    _init_getTmpFolder(_result);
    return _result;
  }
  
  private final HashMap<ArrayList<?>, File> _createCache_getTmpFolder = CollectionLiterals.newHashMap();
  
  private void _init_getTmpFolder(final File path) {
  }
  
  protected static void copyFile(final String from, final String to) {
    try {
      File _file = new File(from);
      StringConcatenation _builder = new StringConcatenation();
      int _length = to.length();
      int _minus = (_length - 2);
      String _substring = to.substring(0, _minus);
      _builder.append(_substring, "");
      _builder.append("Expected.g");
      File _file_1 = new File(_builder.toString());
      Files.copy(_file, _file_1);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * little helper for cleaning up the temporary stuff.
   */
  private static void deleteDir(final File dir) {
    try {
      boolean _exists = dir.exists();
      boolean _not = (!_exists);
      if (_not) {
        return;
      }
      org.eclipse.xtext.util.Files.sweepFolder(dir);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private final static Logger LOG = Logger.getLogger(XtextAntlrGeneratorComparisonFragment.class);
  
  @Pure
  public AntlrOptions getOptions() {
    return this.options;
  }
  
  public void setOptions(final AntlrOptions options) {
    this.options = options;
  }
  
  @Pure
  public boolean isPartialParsing() {
    return this.partialParsing;
  }
  
  public void setPartialParsing(final boolean partialParsing) {
    this.partialParsing = partialParsing;
  }
  
  @Pure
  public boolean isSkipContentAssistGrammarComparison() {
    return this.skipContentAssistGrammarComparison;
  }
  
  public void setSkipContentAssistGrammarComparison(final boolean skipContentAssistGrammarComparison) {
    this.skipContentAssistGrammarComparison = skipContentAssistGrammarComparison;
  }
}
