/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.list.SimpleListProperty;

public abstract class DelegatingListProperty
extends ListProperty {
    private final IListProperty nullProperty;
    private final Object elementType;

    protected DelegatingListProperty() {
        this(null);
    }

    protected DelegatingListProperty(Object elementType) {
        this.elementType = elementType;
        this.nullProperty = new NullListProperty();
    }

    public final IListProperty getDelegate(Object source) {
        if (source == null) {
            return this.nullProperty;
        }
        IListProperty delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract IListProperty doGetDelegate(Object var1);

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    protected List doGetList(Object source) {
        return this.getDelegate(source).getList(source);
    }

    @Override
    protected void doSetList(Object source, List list) {
        this.getDelegate(source).setList(source, list);
    }

    @Override
    protected void doUpdateList(Object source, ListDiff diff) {
        this.getDelegate(source).updateList(source, diff);
    }

    @Override
    public IObservableList observe(Object source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableList observe(Realm realm, Object source) {
        return this.getDelegate(source).observe(realm, source);
    }

    private class NullListProperty
    extends SimpleListProperty {
        private NullListProperty() {
        }

        @Override
        public Object getElementType() {
            return DelegatingListProperty.this.elementType;
        }

        @Override
        protected List doGetList(Object source) {
            return Collections.EMPTY_LIST;
        }

        @Override
        protected void doSetList(Object source, List list, ListDiff diff) {
        }

        @Override
        protected void doSetList(Object source, List list) {
        }

        @Override
        protected void doUpdateList(Object source, ListDiff diff) {
        }

        @Override
        public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
            return null;
        }
    }
}

