/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.PListParser;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;

public class MacInstalledJREs {
    private static final String JAVA_HOME_PLIST = "/usr/libexec/java_home";
    private static final String PLIST_JVM_HOME_PATH = "JVMHomePath";
    private static final String PLIST_JVM_NAME = "JVMName";
    private static final String PLIST_JVM_VERSION = "JVMVersion";
    private static final String PLIST_JVM_BUNDLE_ID = "JVMBundleID";
    public static final VMStandin[] NO_VMS = new VMStandin[0];

    public static VMStandin[] getInstalledJREs(IProgressMonitor monitor) throws CoreException {
        SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            File java_home = new File(JAVA_HOME_PLIST);
            if (!java_home.exists()) {
                throw new CoreException((IStatus)new Status(2, LaunchingPlugin.getUniqueIdentifier(), "The java_home executable does not exist"));
            }
            String[] cmdLine = new String[]{JAVA_HOME_PLIST, "-X"};
            Process p = null;
            try {
                p = DebugPlugin.exec((String[])cmdLine, null);
                IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"JRE Install Detection");
                int i = 0;
                while (i < 600) {
                    if (process.isTerminated()) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
                VMStandin[] vMStandinArray = MacInstalledJREs.parseJREInfo(process, monitor);
                if (p != null) {
                    p.destroy();
                }
                return vMStandinArray;
            }
            catch (Throwable throwable) {
                if (p != null) {
                    p.destroy();
                }
                throw throwable;
            }
        }
        finally {
            if (!smonitor.isCanceled()) {
                smonitor.done();
            }
        }
    }

    private static VMStandin[] parseJREInfo(IProcess process, IProgressMonitor monitor) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        String text = null;
        if (streamsProxy != null) {
            text = streamsProxy.getOutputStreamMonitor().getContents();
        }
        if (text != null && text.length() > 0) {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes());
            return MacInstalledJREs.parseJREInfo(stream, monitor);
        }
        return NO_VMS;
    }

    public static VMStandin[] parseJREInfo(InputStream stream, IProgressMonitor monitor) {
        SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)LaunchingMessages.MacInstalledJREs_0, (int)10);
        try {
            Object result = new PListParser().parse(stream);
            if (result instanceof Object[]) {
                Object[] maps = (Object[])result;
                smonitor.setWorkRemaining(maps.length);
                ArrayList<MacVMStandin> jres = new ArrayList<MacVMStandin>();
                AbstractVMInstallType mactype = (AbstractVMInstallType)JavaRuntime.getVMInstallType("org.eclipse.jdt.internal.launching.macosx.MacOSXType");
                if (mactype != null) {
                    int i = 0;
                    while (i < maps.length) {
                        if (smonitor.isCanceled()) {
                            VMStandin[] vMStandinArray = jres.toArray(new VMStandin[jres.size()]);
                            return vMStandinArray;
                        }
                        Object object = maps[i];
                        if (object instanceof Map) {
                            Map map = (Map)object;
                            Object home = map.get(PLIST_JVM_HOME_PATH);
                            Object name = map.get(PLIST_JVM_NAME);
                            Object version = map.get(PLIST_JVM_VERSION);
                            if (home instanceof String && name instanceof String && version instanceof String) {
                                smonitor.setTaskName(NLS.bind((String)LaunchingMessages.MacInstalledJREs_1, (Object[])new String[]{(String)name, (String)version}));
                                String ver = (String)version;
                                File loc = new File((String)home);
                                StringBuffer namebuff = new StringBuffer(name.toString());
                                namebuff.append(" [").append(ver).append("]");
                                MacVMStandin vm = new MacVMStandin(mactype, loc, namebuff.toString(), ver, MacInstalledJREs.computeId(map, ver));
                                vm.setJavadocLocation(mactype.getDefaultJavadocLocation(loc));
                                vm.setLibraryLocations(mactype.getDefaultLibraryLocations(loc));
                                vm.setVMArgs(mactype.getDefaultVMArguments(loc));
                                if (!jres.contains(vm)) {
                                    jres.add(vm);
                                }
                            }
                        }
                        smonitor.worked(1);
                        ++i;
                    }
                }
                VMStandin[] vMStandinArray = jres.toArray(new VMStandin[jres.size()]);
                return vMStandinArray;
            }
        }
        catch (CoreException ce) {
            LaunchingPlugin.log(ce);
        }
        finally {
            smonitor.done();
        }
        return NO_VMS;
    }

    static String computeId(Map<?, ?> map, String version) {
        Object o = map.get(PLIST_JVM_BUNDLE_ID);
        if (o instanceof String) {
            return (String)o;
        }
        return version;
    }

    public static class MacVMStandin
    extends VMStandin {
        String version = null;

        public MacVMStandin(IVMInstallType type, File location, String name, String version, String id) {
            super(type, id);
            this.setInstallLocation(location);
            this.setName(name);
            this.version = version;
        }

        @Override
        public String getJavaVersion() {
            return this.version;
        }
    }
}

