/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

public class ExtensionScopeHelper {
    private LightweightTypeReference rawArgumentType;
    private LightweightTypeReference argumentType;
    private boolean resolvedComputed;
    private boolean resolved;

    public ExtensionScopeHelper(LightweightTypeReference argumentType) {
        this.argumentType = argumentType;
        this.rawArgumentType = argumentType.getRawTypeReference();
    }

    protected boolean isPossibleExtension(JvmFeature feature) {
        if (!(feature instanceof JvmOperation)) {
            return false;
        }
        EList parameters = ((JvmExecutable)feature).getParameters();
        return !parameters.isEmpty();
    }

    protected boolean isResolvedReceiverType() {
        if (this.resolvedComputed) {
            return this.resolved;
        }
        this.resolvedComputed = true;
        this.resolved = this.isResolvedOrKnownTypeParam(this.argumentType);
        return this.resolved;
    }

    protected boolean isMatchingFirstParameterDeepCheck(JvmOperation feature) {
        if (this.isMatchingFirstParameter(feature)) {
            LightweightTypeReference parameterType;
            return !this.isResolvedReceiverType() || !this.isResolvedOrKnownTypeParam(parameterType = this.argumentType.getOwner().toLightweightTypeReference(((JvmFormalParameter)feature.getParameters().get(0)).getParameterType())) || parameterType.isAssignableFrom(this.argumentType);
        }
        return false;
    }

    protected boolean isMatchingFirstParameter(JvmOperation feature) {
        EList parameters = feature.getParameters();
        JvmFormalParameter firstParameter = (JvmFormalParameter)parameters.get(0);
        JvmTypeReference type = firstParameter.getParameterType();
        if (type == null) {
            return false;
        }
        JvmType rawParameterType = type.getType();
        if (rawParameterType == null || rawParameterType.eIsProxy()) {
            return false;
        }
        if (!(rawParameterType instanceof JvmTypeParameter)) {
            if (this.rawArgumentType.isResolved()) {
                LightweightTypeReference parameterTypeReference = this.rawArgumentType.getOwner().toPlainTypeReference(rawParameterType);
                if (parameterTypeReference.isResolved() && !parameterTypeReference.isAssignableFrom(this.rawArgumentType)) {
                    return parameterTypeReference.isArray() && !this.rawArgumentType.isArray() && this.rawArgumentType.isSubtypeOf(Iterable.class);
                }
                if (parameterTypeReference.isArray() && !this.rawArgumentType.isArray() && !this.rawArgumentType.isSubtypeOf(Iterable.class)) {
                    return false;
                }
            } else if (this.isArrayTypeMismatch(this.rawArgumentType, rawParameterType)) {
                return false;
            }
        }
        return true;
    }

    private boolean isArrayTypeMismatch(LightweightTypeReference rawReceiverType, JvmType rawParameterType) {
        LightweightTypeReference parameterTypeReference;
        return rawReceiverType.isArray() && (parameterTypeReference = rawReceiverType.getOwner().toPlainTypeReference(rawParameterType)).getSuperType(Iterable.class) == null && this.isArrayTypeMismatch(rawReceiverType, parameterTypeReference);
    }

    private boolean isArrayTypeMismatch(LightweightTypeReference receiverType, LightweightTypeReference parameterType) {
        if (receiverType.isArray()) {
            if (parameterType.isArray()) {
                LightweightTypeReference componentType = parameterType.getComponentType();
                return this.isArrayTypeMismatch(receiverType.getComponentType(), componentType);
            }
            return true;
        }
        return !parameterType.isArray() && parameterType.isPrimitive();
    }

    protected boolean isResolvedOrKnownTypeParam(LightweightTypeReference type) {
        return type.accept(new IsResolvedKnownTypeParamHelper());
    }

    protected static class IsResolvedKnownTypeParamHelper
    extends TypeReferenceVisitorWithResult<Boolean> {
        protected IsResolvedKnownTypeParamHelper() {
        }

        @Override
        protected Boolean doVisitTypeReference(LightweightTypeReference reference) {
            return reference.isResolved();
        }

        @Override
        protected Boolean doVisitArrayTypeReference(ArrayTypeReference reference) {
            return reference.getComponentType().accept(this);
        }

        @Override
        protected Boolean doVisitWildcardTypeReference(WildcardTypeReference reference) {
            if (reference.isResolved()) {
                return true;
            }
            if (!this.visit(reference.getUpperBounds())) {
                return false;
            }
            LightweightTypeReference lowerBound = reference.getLowerBound();
            if (lowerBound != null) {
                return lowerBound.accept(this);
            }
            return true;
        }

        @Override
        protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
            if (reference.isResolved()) {
                return true;
            }
            if (reference.getOwner().getDeclaredTypeParameters().contains(reference.getType())) {
                return true;
            }
            if (!this.visit(reference.getTypeArguments())) {
                return false;
            }
            return !(reference.getType() instanceof JvmTypeParameter);
        }

        @Override
        protected Boolean doVisitCompoundTypeReference(CompoundTypeReference reference) {
            if (reference.isResolved()) {
                return true;
            }
            return this.visit(reference.getMultiTypeComponents());
        }

        protected boolean visit(List<LightweightTypeReference> list) {
            for (LightweightTypeReference arg : list) {
                if (arg.accept(this).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

