/*******************************************************************************
 * Copyright (c) 2012 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.formats.svg.svg;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Document Event Attributes</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnunload <em>Onunload</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnabort <em>Onabort</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnerror <em>Onerror</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnresize <em>Onresize</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnscroll <em>Onscroll</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnzoom <em>Onzoom</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface DocumentEventAttributes extends EObject {
	/**
	 * Returns the value of the '<em><b>Onunload</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onunload</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onunload</em>' attribute.
	 * @see #setOnunload(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onunload()
	 * @model
	 * @generated
	 */
	String getOnunload();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnunload <em>Onunload</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onunload</em>' attribute.
	 * @see #getOnunload()
	 * @generated
	 */
	void setOnunload(String value);

	/**
	 * Returns the value of the '<em><b>Onabort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onabort</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onabort</em>' attribute.
	 * @see #setOnabort(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onabort()
	 * @model
	 * @generated
	 */
	String getOnabort();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnabort <em>Onabort</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onabort</em>' attribute.
	 * @see #getOnabort()
	 * @generated
	 */
	void setOnabort(String value);

	/**
	 * Returns the value of the '<em><b>Onerror</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onerror</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onerror</em>' attribute.
	 * @see #setOnerror(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onerror()
	 * @model
	 * @generated
	 */
	String getOnerror();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnerror <em>Onerror</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onerror</em>' attribute.
	 * @see #getOnerror()
	 * @generated
	 */
	void setOnerror(String value);

	/**
	 * Returns the value of the '<em><b>Onresize</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onresize</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onresize</em>' attribute.
	 * @see #setOnresize(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onresize()
	 * @model
	 * @generated
	 */
	String getOnresize();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnresize <em>Onresize</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onresize</em>' attribute.
	 * @see #getOnresize()
	 * @generated
	 */
	void setOnresize(String value);

	/**
	 * Returns the value of the '<em><b>Onscroll</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onscroll</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onscroll</em>' attribute.
	 * @see #setOnscroll(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onscroll()
	 * @model
	 * @generated
	 */
	String getOnscroll();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnscroll <em>Onscroll</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onscroll</em>' attribute.
	 * @see #getOnscroll()
	 * @generated
	 */
	void setOnscroll(String value);

	/**
	 * Returns the value of the '<em><b>Onzoom</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Onzoom</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Onzoom</em>' attribute.
	 * @see #setOnzoom(String)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getDocumentEventAttributes_Onzoom()
	 * @model
	 * @generated
	 */
	String getOnzoom();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.DocumentEventAttributes#getOnzoom <em>Onzoom</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Onzoom</em>' attribute.
	 * @see #getOnzoom()
	 * @generated
	 */
	void setOnzoom(String value);

} // DocumentEventAttributes
