/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.operations.RemediationResolutionJob;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Remedy;
import org.eclipse.equinox.p2.operations.RemedyConfig;
import org.eclipse.equinox.p2.operations.RemedyIUDetail;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemediationOperation
extends ProfileChangeOperation {
    private static int ZERO_WEIGHT = 0;
    private static int LOW_WEIGHT = 1;
    private static int MEDIUM_WEIGHT = 2;
    private static int HIGH_WEIGHT = 3;
    private List<Remedy> remedies;
    private Remedy bestSolutionChangingTheRequest;
    private Remedy bestSolutionChangingWhatIsInstalled;
    private Remedy currentRemedy;
    private RemedyConfig[] remedyConfigs;
    private IProfileChangeRequest originalRequest;

    public RemedyConfig[] getRemedyConfigs() {
        return this.remedyConfigs;
    }

    public Remedy getCurrentRemedy() {
        return this.currentRemedy;
    }

    public void setCurrentRemedy(Remedy currentRemedy) {
        this.currentRemedy = currentRemedy;
        this.request = currentRemedy == null ? null : currentRemedy.getRequest();
    }

    public RemediationOperation(ProvisioningSession session, IProfileChangeRequest iProfileChangeRequest) {
        this(session, iProfileChangeRequest, RemedyConfig.getAllRemedyConfigs());
    }

    public RemediationOperation(ProvisioningSession session, IProfileChangeRequest originalRequest, RemedyConfig[] remedyConfigs) {
        super(session);
        this.originalRequest = originalRequest;
        this.remedies = new ArrayList<Remedy>();
        this.remedyConfigs = remedyConfigs;
    }

    public Remedy bestSolutionChangingTheRequest() {
        return this.bestSolutionChangingTheRequest;
    }

    public Remedy bestSolutionChangingWhatIsInstalled() {
        return this.bestSolutionChangingWhatIsInstalled;
    }

    public List<Remedy> getRemedies() {
        return this.remedies;
    }

    @Override
    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (this.currentRemedy != null) {
            this.request = this.currentRemedy.getRequest();
            sub.worked(1);
            return;
        }
        try {
            status.add(this.computeAllRemediations((IProgressMonitor)sub.newChild(1)));
        }
        catch (OperationCanceledException operationCanceledException) {
            status.add(Status.CANCEL_STATUS);
        }
        this.determineBestSolutions();
    }

    private IStatus computeAllRemediations(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.remedyConfigs.length);
        sub.setTaskName(Messages.RemediationOperation_ProfileChangeRequestProgress);
        ArrayList<Remedy> tmpRemedies = new ArrayList<Remedy>(this.remedyConfigs.length);
        try {
            int i = 0;
            while (i < this.remedyConfigs.length) {
                sub.subTask(String.valueOf(i + 1) + " / " + this.remedyConfigs.length);
                if (sub.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Remedy remedy = this.computeRemedy(this.remedyConfigs[i], (IProgressMonitor)sub.newChild(1, 7));
                if (remedy != null) {
                    tmpRemedies.add(remedy);
                }
                ++i;
            }
        }
        finally {
            sub.done();
        }
        this.remedies = tmpRemedies;
        return this.getResolutionResult();
    }

    private void determineBestSolutions() {
        int beingInstalledWeight = 0;
        int installationWeight = 0;
        for (Remedy remedy : this.remedies) {
            if (remedy.getRequest() == null) continue;
            if (remedy.getBeingInstalledRelaxedWeight() > beingInstalledWeight && remedy.getInstallationRelaxedWeight() == 0) {
                this.bestSolutionChangingTheRequest = remedy;
                beingInstalledWeight = remedy.getBeingInstalledRelaxedWeight();
                continue;
            }
            if (remedy.getInstallationRelaxedWeight() <= installationWeight || remedy.getBeingInstalledRelaxedWeight() != 0) continue;
            this.bestSolutionChangingWhatIsInstalled = remedy;
            installationWeight = remedy.getInstallationRelaxedWeight();
        }
    }

    private Remedy computeRemedy(RemedyConfig configuration, IProgressMonitor monitor) {
        Remedy remedy = new Remedy(this.originalRequest);
        remedy.setConfig(configuration);
        IPlanner planner = this.session.getPlanner();
        RequestFlexer av = new RequestFlexer(planner);
        av.setAllowDifferentVersion(configuration.allowDifferentVersion);
        av.setAllowInstalledElementChange(configuration.allowInstalledUpdate);
        av.setAllowInstalledElementRemoval(configuration.allowInstalledRemoval);
        av.setAllowPartialInstall(configuration.allowPartialInstall);
        av.setProvisioningContext(this.getProvisioningContext());
        remedy.setRequest((ProfileChangeRequest)av.getChangeRequest(this.originalRequest, ((ProfileChangeRequest)this.originalRequest).getProfile(), monitor));
        if (remedy.getRequest() == null) {
            return null;
        }
        if (configuration.allowInstalledUpdate && !configuration.allowInstalledRemoval) {
            remedy.setInstallationRelaxedWeight(HIGH_WEIGHT);
        } else if (!configuration.allowInstalledUpdate && configuration.allowInstalledRemoval) {
            remedy.setInstallationRelaxedWeight(MEDIUM_WEIGHT);
        } else if (configuration.allowInstalledUpdate && configuration.allowInstalledRemoval) {
            remedy.setInstallationRelaxedWeight(LOW_WEIGHT);
        } else {
            remedy.setInstallationRelaxedWeight(ZERO_WEIGHT);
        }
        if (configuration.allowDifferentVersion && !configuration.allowPartialInstall) {
            remedy.setBeingInstalledRelaxedWeight(HIGH_WEIGHT);
        } else if (!configuration.allowDifferentVersion && configuration.allowPartialInstall) {
            remedy.setBeingInstalledRelaxedWeight(MEDIUM_WEIGHT);
        } else if (configuration.allowDifferentVersion && configuration.allowPartialInstall) {
            remedy.setBeingInstalledRelaxedWeight(LOW_WEIGHT);
        } else {
            remedy.setBeingInstalledRelaxedWeight(ZERO_WEIGHT);
        }
        this.computeRemedyDetails(remedy);
        return remedy;
    }

    @Override
    protected String getResolveJobName() {
        return Messages.RemediationOperation_ResolveJobName;
    }

    @Override
    protected String getProvisioningJobName() {
        return Messages.RemediationOperation_RemediationJobName;
    }

    @Override
    public ProvisioningJob getProvisioningJob(IProgressMonitor monitor) {
        IStatus status = this.getResolutionResult();
        if (status.getSeverity() != 8 && status.getSeverity() != 4 && this.job.getProvisioningPlan() != null) {
            ProfileModificationJob pJob = new ProfileModificationJob(this.getProvisioningJobName(), this.session, this.profileId, this.job.getProvisioningPlan(), this.job.getActualProvisioningContext());
            pJob.setAdditionalProgressMonitor(monitor);
            return pJob;
        }
        return null;
    }

    public ProfileChangeRequest getOriginalRequest() {
        return (ProfileChangeRequest)this.originalRequest;
    }

    @Override
    void makeResolveJob(IProgressMonitor monitor) {
        this.request = null;
        this.noChangeRequest = PlanAnalyzer.getProfileChangeAlteredStatus();
        final ProfileChangeRequest[] requestHolder = new ProfileChangeRequest[1];
        this.job = new RemediationResolutionJob(this.getResolveJobName(), this.session, this.profileId, this.request, this.getFirstPassProvisioningContext(), this.getSecondPassEvaluator(), this.noChangeRequest, new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) throws OperationCanceledException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)mon, (int)2);
                if (RemediationOperation.this.job.getState() == 0 && RemediationOperation.this.session.hasScheduledOperationsFor(RemediationOperation.this.profileId)) {
                    RemediationOperation.this.noChangeRequest.add(PlanAnalyzer.getStatus(10052, null));
                } else {
                    sub.worked(1);
                    RemediationOperation.this.computeProfileChangeRequest(RemediationOperation.this.noChangeRequest, (IProgressMonitor)sub.newChild(1));
                    requestHolder[0] = RemediationOperation.this.request;
                }
            }
        }, requestHolder, this);
    }

    @Override
    public IStatus getResolutionResult() {
        if (this.currentRemedy != null) {
            return super.getResolutionResult();
        }
        return this.remedies.size() > 0 ? Status.OK_STATUS : new Status(4, "org.eclipse.equinox.p2.operations", Messages.RemediationOperation_NoRemedyFound);
    }

    private void computeRemedyDetails(Remedy remedy) {
        ArrayList<String> updateIds = new ArrayList<String>();
        for (IInstallableUnit addedIU : remedy.getRequest().getAdditions()) {
            for (IInstallableUnit removedIU : remedy.getRequest().getRemovals()) {
                if (!removedIU.getId().equals(addedIU.getId())) continue;
                this.createModificationRemedyDetail(addedIU, removedIU, remedy);
                updateIds.add(addedIU.getId());
                break;
            }
            if (updateIds.contains(addedIU.getId())) continue;
            this.createAdditionRemedyDetail(addedIU, remedy);
        }
        for (IInstallableUnit removedIU : remedy.getRequest().getRemovals()) {
            if (updateIds.contains(removedIU.getId())) continue;
            this.createRemovalRemedyDetail(removedIU, remedy);
        }
        for (IInstallableUnit addedIUinOriginalRequest : this.originalRequest.getAdditions()) {
            boolean found = false;
            for (IInstallableUnit addedIU : remedy.getRequest().getAdditions()) {
                if (!addedIU.getId().equals(addedIUinOriginalRequest.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.createNotAddedRemedyDetail(addedIUinOriginalRequest, remedy);
            found = false;
        }
    }

    private void createNotAddedRemedyDetail(IInstallableUnit iu, Remedy remedy) {
        RemedyIUDetail iuDetail = new RemedyIUDetail(iu);
        iuDetail.setStatus(3);
        iuDetail.setRequestedVersion(iu.getVersion());
        remedy.addRemedyIUDetail(iuDetail);
    }

    private void createRemovalRemedyDetail(IInstallableUnit iu, Remedy remedy) {
        RemedyIUDetail iuDetail = new RemedyIUDetail(iu);
        iuDetail.setStatus(2);
        iuDetail.setInstalledVersion(iu.getVersion());
        remedy.addRemedyIUDetail(iuDetail);
    }

    private void createAdditionRemedyDetail(IInstallableUnit iu, Remedy remedy) {
        RemedyIUDetail iuDetail = new RemedyIUDetail(iu);
        iuDetail.setStatus(1);
        iuDetail.setBeingInstalledVersion(iu.getVersion());
        iuDetail.setRequestedVersion(this.searchInOriginalRequest(iu.getId()));
        remedy.addRemedyIUDetail(iuDetail);
    }

    private void createModificationRemedyDetail(IInstallableUnit beingInstalledIU, IInstallableUnit installedIU, Remedy remedy) {
        RemedyIUDetail iuDetail = new RemedyIUDetail(beingInstalledIU);
        iuDetail.setStatus(4);
        iuDetail.setBeingInstalledVersion(beingInstalledIU.getVersion());
        iuDetail.setInstalledVersion(installedIU.getVersion());
        iuDetail.setRequestedVersion(this.searchInOriginalRequest(beingInstalledIU.getId()));
        remedy.addRemedyIUDetail(iuDetail);
    }

    private Version searchInOriginalRequest(String id) {
        for (IInstallableUnit iu : this.originalRequest.getAdditions()) {
            if (iu.getId() != id) continue;
            return iu.getVersion();
        }
        return null;
    }
}

