/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.operations.Activator;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;

public class ProvisioningSession {
    private IProvisioningAgent agent;
    Set<Job> scheduledJobs = Collections.synchronizedSet(new HashSet());

    public ProvisioningSession(IProvisioningAgent agent) {
        Assert.isNotNull((Object)agent, (String)Messages.ProvisioningSession_AgentNotFound);
        this.agent = agent;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.agent;
    }

    IAgentLocation getAgentLocation() {
        return (IAgentLocation)this.agent.getService(IAgentLocation.SERVICE_NAME);
    }

    IArtifactRepositoryManager getArtifactRepositoryManager() {
        return (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    IProfileRegistry getProfileRegistry() {
        return (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
    }

    IEngine getEngine() {
        return (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
    }

    IProvisioningEventBus getProvisioningEventBus() {
        return (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.SERVICE_NAME);
    }

    IPlanner getPlanner() {
        return (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
    }

    public IStatus performProvisioningPlan(IProvisioningPlan plan, IPhaseSet phaseSet, ProvisioningContext context, IProgressMonitor monitor) {
        IPhaseSet set = phaseSet == null ? PhaseSetFactory.createDefaultPhaseSet() : phaseSet;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
        int ticksUsed = 0;
        IProfile profile = plan.getProfile();
        if (plan.getInstallerPlan() != null) {
            IStatus installerPlanStatus;
            if (this.doesPhaseSetIncludeDownload(set)) {
                IProvisioningPlan downloadPlan = this.getEngine().createPlan(profile, context);
                Iterator it = QueryUtil.compoundQueryable((IQueryable)plan.getAdditions(), (IQueryable)plan.getInstallerPlan().getAdditions()).query(QueryUtil.createIUAnyQuery(), null).iterator();
                while (it.hasNext()) {
                    downloadPlan.addInstallableUnit((IInstallableUnit)it.next());
                }
                IPhaseSet download = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT});
                IStatus downloadStatus = this.getEngine().perform(downloadPlan, download, (IProgressMonitor)mon.newChild(300));
                if (!downloadStatus.isOK()) {
                    mon.done();
                    return downloadStatus;
                }
                ticksUsed = 300;
            }
            if (!(installerPlanStatus = this.getEngine().perform(plan.getInstallerPlan(), set, (IProgressMonitor)mon.newChild(100))).isOK()) {
                mon.done();
                return installerPlanStatus;
            }
            ticksUsed += 100;
            Configurator configChanger = (Configurator)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)Configurator.class.getName());
            try {
                configChanger.applyConfiguration();
            }
            catch (IOException e) {
                mon.done();
                return new Status(4, "org.eclipse.equinox.p2.operations", Messages.ProvisioningSession_InstallPlanConfigurationError, (Throwable)e);
            }
        }
        return this.getEngine().perform(plan, set, (IProgressMonitor)mon.newChild(500 - ticksUsed));
    }

    private boolean doesPhaseSetIncludeDownload(IPhaseSet set) {
        String[] phaseIds = set.getPhaseIds();
        int i = 0;
        while (i < phaseIds.length) {
            if (phaseIds[i].equals(PhaseSetFactory.PHASE_COLLECT)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasScheduledOperationsFor(String profileId) {
        Job[] jobs = this.getScheduledJobs();
        int i = 0;
        while (i < jobs.length) {
            String id;
            if (jobs[i] instanceof IProfileChangeJob && profileId.equals(id = ((IProfileChangeJob)jobs[i]).getProfileId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job[] getScheduledJobs() {
        Set<Job> set = this.scheduledJobs;
        synchronized (set) {
            return this.scheduledJobs.toArray(new Job[this.scheduledJobs.size()]);
        }
    }

    public void rememberJob(Job job) {
        this.scheduledJobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ProvisioningSession.this.scheduledJobs.remove(event.getJob());
            }
        });
    }
}

