/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.command.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCommandInterpreter
implements CommandInterpreter {
    private PrintStream out = System.out;
    private String tab = "\t";
    private String newline = "\r\n";
    private final Iterator<Object> arguments;
    private final CommandSession commandSession;
    protected static int maxLineCount;
    protected int currentLineCount;

    public CustomCommandInterpreter(CommandSession commandSession, List<Object> args) {
        this.commandSession = commandSession;
        this.arguments = args.iterator();
    }

    public Object execute(String cmd) {
        try {
            return this.commandSession.execute((CharSequence)cmd);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String nextArgument() {
        if (this.arguments.hasNext()) {
            Object next = this.arguments.next();
            return next == null ? null : next.toString();
        }
        return null;
    }

    public void print(Object o) {
        this.check4More();
        this.out.print(o);
        this.out.flush();
    }

    public void println() {
        this.println("");
    }

    public void printStackTrace(Throwable t) {
        t.printStackTrace(this.out);
        Method[] methods = t.getClass().getMethods();
        int size = methods.length;
        Class<Throwable> throwable = Throwable.class;
        int i = 0;
        while (i < size) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && throwable.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                try {
                    Throwable nested = (Throwable)method.invoke((Object)t, new Object[]{null});
                    if (nested != null && nested != t) {
                        this.out.println("Nested Exception");
                        this.printStackTrace(nested);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o) {
        if (o == null) {
            return;
        }
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.check4More();
            this.printline(o);
            ++this.currentLineCount;
            this.currentLineCount += o.toString().length() / 80;
        }
    }

    private void printline(Object o) {
        this.print(o + this.newline);
    }

    public void printDictionary(Dictionary<?, ?> dic, String title) {
        if (dic == null) {
            return;
        }
        int count = dic.size();
        Object[] keys = new String[count];
        Enumeration<?> keysEnum = dic.keys();
        int i = 0;
        while (keysEnum.hasMoreElements()) {
            keys[i++] = (String)keysEnum.nextElement();
        }
        Arrays.sort(keys);
        if (title != null) {
            this.println(title);
        }
        i = 0;
        while (i < count) {
            this.println(" " + (String)keys[i] + " = " + dic.get(keys[i]));
            ++i;
        }
        this.println();
    }

    public void printBundleResource(Bundle bundle, String resource) {
        block12: {
            URL entry = null;
            entry = bundle.getEntry(resource);
            if (entry != null) {
                try {
                    this.println(resource);
                    InputStream in = entry.openStream();
                    byte[] buffer = new byte[1024];
                    int read = 0;
                    try {
                        while ((read = in.read(buffer)) != -1) {
                            this.print(new String(buffer, 0, read));
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (in == null) break block12;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            } else {
                this.println("CONSOLE_RESOURCE [" + resource + "] NOT_IN_BUNDLE " + bundle.toString());
            }
        }
    }

    private int getMaximumLinesToScroll() {
        return maxLineCount;
    }

    private void check4More() {
        int max = this.getMaximumLinesToScroll();
        if (max > 0 && this.currentLineCount >= max) {
            this.out.print("-- More...Press Enter to Continue...");
            this.out.flush();
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.resetLineCount();
        }
    }

    private void resetLineCount() {
        this.currentLineCount = 0;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(256);
        help.append("---Controlling the Console---");
        help.append(this.newline);
        help.append(this.tab);
        help.append("more - ");
        help.append("More prompt for console output");
        help.append(this.newline);
        help.append(this.tab);
        help.append("disconnect - ");
        help.append("isconnects from telnet session");
        help.append(this.newline);
        return help.toString();
    }
}

