/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.KeyComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class ListExtensions {
    public static <T extends Comparable<? super T>> List<T> sortInplace(List<T> list) {
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> sortInplace(List<T> list, Comparator<? super T> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <T, C extends Comparable<? super C>> List<T> sortInplaceBy(List<T> list, Functions.Function1<? super T, C> key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Collections.sort(list, new KeyComparator<T, C>(key));
        return list;
    }

    @Pure
    public static <T> List<T> reverseView(List<T> list) {
        return Lists.reverse(list);
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    @Pure
    public static <T, R> List<R> map(List<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        return Lists.transform(original, new FunctionDelegate<T, R>(transformation));
    }
}

