/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javafx.application.Application;
import javafx.stage.Stage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.osgi.util.AbstractJFXApplication;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class DIApplication
extends AbstractJFXApplication
implements IExecutableExtension {
    private @Nullable String bundleName;
    private @Nullable String applicationClass;

    protected void jfxStart(IApplicationContext applicationContext, Application jfxApplication, Stage primaryStage) {
        String bundleName = this.bundleName;
        String applicationClass = this.applicationClass;
        if (bundleName == null || bundleName.isEmpty()) {
            throw new IllegalStateException("The bundle '" + bundleName + "' to load from is not known");
        }
        if (applicationClass == null || applicationClass.isEmpty()) {
            throw new IllegalStateException("The application class '" + applicationClass + "' to load from is not known");
        }
        BundleContext context = FrameworkUtil.getBundle(DIApplication.class).getBundleContext();
        ArrayList<Bundle> sorted = new ArrayList<Bundle>(Arrays.asList(context.getBundles()));
        Collections.sort(sorted, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                return b2.getVersion().compareTo(b1.getVersion());
            }
        });
        for (Bundle b : sorted) {
            if (!bundleName.equals(b.getSymbolicName())) continue;
            if ((b.getState() & 2) == 0) {
                if ((b.getState() & 0x20) != 0) {
                    try {
                        b.start();
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Class cl = b.loadClass(this.applicationClass);
                    IEclipseContext eContext = EclipseContextFactory.getServiceContext((BundleContext)context);
                    ContextInjectionFactory.setDefault((IEclipseContext)eContext);
                    eContext.set(IApplicationContext.class, (Object)applicationContext);
                    eContext.set(Application.class, (Object)jfxApplication);
                    eContext.set(Stage.class, (Object)primaryStage);
                    ContextInjectionFactory.make((Class)cl, (IEclipseContext)eContext);
                }
                catch (Throwable e) {
                    LoggerCreator.createLogger(((Object)((Object)this)).getClass()).error("Unabled to create instance of '" + this.applicationClass + "'", e);
                }
                continue;
            }
            LoggerCreator.createLogger(((Object)((Object)this)).getClass()).error("Unable to locate bundle: " + this.bundleName);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.bundleName = config.getContributor().getName();
        this.applicationClass = (String)((Map)data).get("mainClass");
    }
}

