/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core.identity;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.identity";
    private static final String NAMESPACE_NAME = "namespace";
    private static final String NAMESPACE_EPOINT = "org.eclipse.ecf.identity.namespace";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final int FACTORY_NAME_COLLISION_ERRORCODE = 200;
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static Activator plugin;
    private BundleContext context;
    private ServiceRegistration idFactoryServiceRegistration;
    private ServiceTracker debugOptionsTracker;
    private ServiceTracker logServiceTracker;
    private LogService logService;
    private AdapterManagerTracker adapterManagerTracker;
    private ServiceTracker namespacesTracker;
    private Object registryManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public synchronized IAdapterManager getAdapterManager() {
        if (this.context == null) {
            return null;
        }
        if (this.adapterManagerTracker == null) {
            this.adapterManagerTracker = new AdapterManagerTracker(this.context);
            this.adapterManagerTracker.open();
        }
        return this.adapterManagerTracker.getAdapterManager();
    }

    public synchronized DebugOptions getDebugOptions() {
        if (this.context == null) {
            return null;
        }
        if (this.debugOptionsTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugOptionsTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.debugOptionsTracker.open();
        }
        return (DebugOptions)this.debugOptionsTracker.getService();
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.identity.IIDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.idFactoryServiceRegistration = this.context.registerService(clazz.getName(), (Object)IDFactory.getDefault(), null);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.core.identity.Namespace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.namespacesTracker = new ServiceTracker(this.context, clazz2.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Namespace ns = (Namespace)Activator.this.context.getService(reference);
                if (ns != null && ns.getName() != null) {
                    IDFactory.addNamespace0(ns);
                }
                return ns;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                IDFactory.removeNamespace0((Namespace)service);
            }
        });
        this.namespacesTracker.open();
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(ctxt){

            protected void runWithRegistry(IExtensionRegistry registry) throws Exception {
                if (registry != null) {
                    Activator.this.registryManager = new IRegistryChangeListener(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void registryChanged(IRegistryChangeEvent event) {
                            IExtensionDelta[] delta = event.getExtensionDeltas("org.eclipse.ecf.identity", "namespace");
                            int i = 0;
                            while (i < delta.length) {
                                switch (delta[i].getKind()) {
                                    case 1: {
                                        2.access$0(this.this$1).addNamespaceExtensions(delta[i].getExtension().getConfigurationElements());
                                        break;
                                    }
                                    case 2: {
                                        IConfigurationElement[] members = delta[i].getExtension().getConfigurationElements();
                                        int m = 0;
                                        while (m < members.length) {
                                            IConfigurationElement member = members[m];
                                            String name = null;
                                            try {
                                                IIDFactory factory;
                                                Namespace n;
                                                name = member.getAttribute("name");
                                                if (name == null) {
                                                    name = member.getAttribute("class");
                                                }
                                                if (name != null && (n = (factory = IDFactory.getDefault()).getNamespaceByName(name)) != null && factory.containsNamespace(n)) {
                                                    factory.removeNamespace(n);
                                                }
                                            }
                                            catch (Exception e) {
                                                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.identity", 4, "Exception removing namespace", (Throwable)e));
                                            }
                                            ++m;
                                        }
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                    };
                    registry.addRegistryChangeListener((IRegistryChangeListener)Activator.this.registryManager);
                }
            }

            static /* synthetic */ Activator access$0(2 var0) {
                return var0.Activator.this;
            }
        });
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    synchronized LogService getLogService() {
        if (this.context == null) {
            if (this.logService == null) {
                this.logService = new SystemLogService(PLUGIN_ID);
            }
            return this.logService;
        }
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode(status), LogHelper.getLogMessage(status), status.getException());
        }
    }

    void addNamespaceExtensions(IConfigurationElement[] members) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String nsName = null;
            try {
                Namespace ns = (Namespace)member.createExecutableExtension(CLASS_ATTRIBUTE);
                String clazz = ns.getClass().getName();
                nsName = member.getAttribute(NAME_ATTRIBUTE);
                if (nsName == null) {
                    nsName = clazz;
                }
                String nsDescription = member.getAttribute(DESCRIPTION_ATTRIBUTE);
                ns.initialize(nsName, nsDescription);
                if (!IDFactory.containsNamespace0(ns)) {
                    IDFactory.addNamespace0(ns);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log(e.getStatus());
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, bundleName, 200, "name=" + nsName + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
            }
            ++m;
        }
    }

    public void setupNamespaceExtensionPoint() {
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(this.context){

            protected void runWithRegistry(IExtensionRegistry registry) throws Exception {
                if (registry != null) {
                    IExtensionPoint extensionPoint = registry.getExtensionPoint(Activator.NAMESPACE_EPOINT);
                    if (extensionPoint == null) {
                        return;
                    }
                    Activator.this.addNamespaceExtensions(extensionPoint.getConfigurationElements());
                }
            }
        });
    }

    public void stop(BundleContext ctxt) throws Exception {
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(ctxt){

            protected void runWithRegistry(IExtensionRegistry registry) throws Exception {
                if (registry != null) {
                    registry.removeRegistryChangeListener((IRegistryChangeListener)Activator.this.registryManager);
                }
            }
        });
        if (this.namespacesTracker != null) {
            this.namespacesTracker.close();
            this.namespacesTracker = null;
        }
        this.registryManager = null;
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.debugOptionsTracker != null) {
            this.debugOptionsTracker.close();
            this.debugOptionsTracker = null;
        }
        if (this.idFactoryServiceRegistration != null) {
            this.idFactoryServiceRegistration.unregister();
            this.idFactoryServiceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }
}

