/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.internal.repository.mirroring.FileMirrorLog;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.internal.repository.mirroring.XMLMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorApplication
extends AbstractApplication
implements IApplication,
IExecutableExtension {
    private static final String LOG_ROOT = "p2.mirror";
    private static final String MIRROR_MODE = "metadataOrArtifacts";
    protected SlicingOptions slicingOptions = new SlicingOptions();
    private URI baseline;
    private String comparatorID;
    private IQuery<IArtifactDescriptor> compareExclusions = null;
    private boolean compare = false;
    private boolean failOnError = true;
    private boolean raw = true;
    private boolean verbose = false;
    private boolean validate = false;
    private boolean mirrorReferences = true;
    private String metadataOrArtifacts = null;
    private String[] rootIUs = null;
    private boolean includePacked = true;
    private File mirrorLogFile;
    private File comparatorLogFile;
    private IArtifactMirrorLog mirrorLog;
    private IArtifactMirrorLog comparatorLog;

    public static String[] getArrayArgsFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            if ((token.indexOf(91) >= 0 || token.indexOf(40) >= 0) && tokens.hasMoreTokens()) {
                result.add(String.valueOf(token) + separator + tokens.nextToken());
                continue;
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object start(IApplicationContext context) throws Exception {
        Map args = context.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        this.run(null);
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof Map && ((Map)data).containsKey(MIRROR_MODE)) {
            this.metadataOrArtifacts = (String)((Map)data).get(MIRROR_MODE);
        }
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        File comparatorLogLocation = null;
        File mirrorLogLocation = null;
        RepositoryDescriptor destination = new RepositoryDescriptor();
        RepositoryDescriptor sourceRepo = new RepositoryDescriptor();
        if (this.metadataOrArtifacts != null) {
            destination.setKind(this.metadataOrArtifacts);
            sourceRepo.setKind(this.metadataOrArtifacts);
        }
        this.addDestination(destination);
        this.addSource(sourceRepo);
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-raw")) {
                this.raw = true;
            } else if (args[i].equalsIgnoreCase("-ignoreErrors")) {
                this.failOnError = false;
            } else if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            } else if (args[i].equalsIgnoreCase("-compare")) {
                this.compare = true;
            } else if (args[i].equalsIgnoreCase("-validate")) {
                this.validate = true;
            } else if (args[i].equalsIgnoreCase("-references")) {
                this.mirrorReferences = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-comparator")) {
                    this.comparatorID = arg;
                } else if (args[i - 1].equalsIgnoreCase("-comparatorLog")) {
                    comparatorLogLocation = new File(arg);
                } else if (args[i - 1].equalsIgnoreCase("-destinationName")) {
                    destination.setName(arg);
                } else if (args[i - 1].equalsIgnoreCase("-writeMode")) {
                    if (args[i].equalsIgnoreCase("clean")) {
                        destination.setAppend(false);
                    }
                } else if (args[i - 1].equalsIgnoreCase("-log")) {
                    mirrorLogLocation = new File(arg);
                } else if (args[i - 1].equalsIgnoreCase("-roots")) {
                    this.rootIUs = MirrorApplication.getArrayArgsFromString(arg, ",");
                } else if (args[i - 1].equalsIgnoreCase("-references")) {
                    this.mirrorReferences = Boolean.parseBoolean(args[i]);
                } else {
                    try {
                        if (args[i - 1].equalsIgnoreCase("-source")) {
                            URI uri = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                            sourceRepo.setLocation(uri);
                            destination.setFormat(uri);
                        } else if (args[i - 1].equalsIgnoreCase("-destination")) {
                            destination.setLocation(RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg)));
                        } else if (args[i - 1].equalsIgnoreCase("-compareAgainst")) {
                            this.baseline = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                            this.compare = true;
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IllegalArgumentException(NLS.bind((String)Messages.ProcessRepo_location_not_url, (Object)arg));
                    }
                }
            }
            ++i;
        }
        if (mirrorLogLocation != null) {
            this.mirrorLog = this.getLog(mirrorLogLocation, "p2.artifact.mirror");
        }
        if (comparatorLogLocation != null && this.comparatorID != null) {
            this.comparatorLog = this.getLog(comparatorLogLocation, this.comparatorID);
        }
    }

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        IStatus mirrorStatus = Status.OK_STATUS;
        try {
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            this.initializeLogs();
            this.validate();
            this.initializeIUs();
            IQueryable<IInstallableUnit> slice = this.slice((IProgressMonitor)new NullProgressMonitor());
            if (this.destinationArtifactRepository != null) {
                mirrorStatus = this.mirrorArtifacts(slice, (IProgressMonitor)new NullProgressMonitor());
                if (this.failOnError && mirrorStatus.getSeverity() == 4) {
                    IStatus iStatus = mirrorStatus;
                    return iStatus;
                }
            }
            if (this.destinationMetadataRepository != null) {
                this.mirrorMetadata(slice, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            this.finalizeRepositories();
            this.finalizeLogs();
        }
        if (mirrorStatus.isOK()) {
            return Status.OK_STATUS;
        }
        return mirrorStatus;
    }

    private IStatus mirrorArtifacts(IQueryable<IInstallableUnit> slice, IProgressMonitor monitor) {
        Mirroring mirror = this.getMirroring(slice, monitor);
        MultiStatus result = mirror.run(this.failOnError, this.verbose);
        if (this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)result);
        } else {
            LogHelper.log((IStatus)result);
        }
        return result;
    }

    protected Mirroring getMirroring(IQueryable<IInstallableUnit> slice, IProgressMonitor monitor) {
        IQueryResult ius = slice.query(QueryUtil.createIUAnyQuery(), monitor);
        boolean iusSpecified = !ius.isEmpty();
        ArrayList keys = new ArrayList();
        for (IInstallableUnit iu : ius) {
            keys.addAll(iu.getArtifacts());
        }
        Mirroring mirror = new Mirroring(this.getCompositeArtifactRepository(), this.destinationArtifactRepository, this.raw);
        mirror.setCompare(this.compare);
        mirror.setComparatorId(this.comparatorID);
        mirror.setBaseline(this.initializeBaseline());
        mirror.setValidate(this.validate);
        mirror.setCompareExclusions(this.compareExclusions);
        mirror.setTransport((Transport)this.agent.getService(Transport.SERVICE_NAME));
        mirror.setIncludePacked(this.includePacked);
        if (iusSpecified) {
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
        }
        if (this.comparatorLog != null) {
            mirror.setComparatorLog(this.comparatorLog);
        }
        return mirror;
    }

    private IArtifactRepository initializeBaseline() {
        if (this.baseline == null) {
            return null;
        }
        try {
            return this.addRepository(this.getArtifactRepositoryManager(), this.baseline, 0, null);
        }
        catch (ProvisionException e) {
            if (this.mirrorLog != null && e.getStatus() != null) {
                this.mirrorLog.log(e.getStatus());
            }
            return null;
        }
    }

    private void mirrorMetadata(IQueryable<IInstallableUnit> slice, IProgressMonitor monitor) {
        IQueryResult allIUs = slice.query(QueryUtil.createIUAnyQuery(), monitor);
        this.destinationMetadataRepository.addInstallableUnits((Collection)allIUs.toUnmodifiableSet());
        if (this.mirrorReferences) {
            this.destinationMetadataRepository.addReferences(this.getCompositeMetadataRepository().getReferences());
        }
    }

    private void validate() throws ProvisionException {
        if (this.sourceRepositories.isEmpty()) {
            throw new ProvisionException(Messages.MirrorApplication_set_source_repositories);
        }
        if (!this.hasArtifactSources() && this.destinationArtifactRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_artifactDestinationNoSource);
        }
        if (!this.hasMetadataSources() && this.destinationMetadataRepository != null) {
            throw new ProvisionException(Messages.MirrorApplication_metadataDestinationNoSource);
        }
    }

    private void initializeIUs() throws ProvisionException {
        IMetadataRepository metadataRepo = this.getCompositeMetadataRepository();
        if (this.rootIUs != null) {
            this.sourceIUs = new ArrayList();
            int i = 0;
            while (i < this.rootIUs.length) {
                String[] segments = MirrorApplication.getArrayArgsFromString(this.rootIUs[i], "/");
                VersionRange range = segments.length > 1 ? new VersionRange(segments[1]) : null;
                Iterator queryResult = metadataRepo.query(QueryUtil.createIUQuery((String)segments[0], (VersionRange)range), null).iterator();
                while (queryResult.hasNext()) {
                    this.sourceIUs.add((IInstallableUnit)queryResult.next());
                }
                ++i;
            }
        } else if (this.sourceIUs == null || this.sourceIUs.isEmpty()) {
            this.sourceIUs = new ArrayList();
            Iterator queryResult = metadataRepo.query(QueryUtil.createIUAnyQuery(), null).iterator();
            while (queryResult.hasNext()) {
                this.sourceIUs.add((IInstallableUnit)queryResult.next());
            }
            if (this.sourceIUs.size() == 0 && this.destinationMetadataRepository != null && this.metadataOrArtifacts == null) {
                throw new ProvisionException(Messages.MirrorApplication_no_IUs);
            }
        }
    }

    private void initializeLogs() {
        if (this.compare && this.comparatorLogFile != null) {
            this.comparatorLog = this.getLog(this.comparatorLogFile, this.comparatorID);
        }
        if (this.mirrorLog == null && this.mirrorLogFile != null) {
            this.mirrorLog = this.getLog(this.mirrorLogFile, LOG_ROOT);
        }
    }

    private void finalizeLogs() {
        if (this.comparatorLog != null) {
            this.comparatorLog.close();
        }
        if (this.mirrorLog != null) {
            this.mirrorLog.close();
        }
    }

    private IArtifactMirrorLog getLog(File location, String root) {
        String absolutePath = location.getAbsolutePath();
        if (absolutePath.toLowerCase().endsWith(".xml")) {
            return new XMLMirrorLog(absolutePath, 0, root);
        }
        return new FileMirrorLog(absolutePath, 0, root);
    }

    private IQueryable<IInstallableUnit> performResolution(IProgressMonitor monitor) throws ProvisionException {
        IProfileRegistry registry = Activator.getProfileRegistry();
        String profileId = "MirrorApplication-" + System.currentTimeMillis();
        IProfile profile = registry.addProfile(profileId, this.slicingOptions.getFilter());
        IPlanner planner = (IPlanner)Activator.getAgent().getService(IPlanner.SERVICE_NAME);
        if (planner == null) {
            throw new IllegalStateException();
        }
        IProfileChangeRequest pcr = planner.createChangeRequest(profile);
        pcr.addAll((Collection)this.sourceIUs);
        IProvisioningPlan plan = planner.getProvisioningPlan(pcr, null, monitor);
        registry.removeProfile(profileId);
        IQueryable[] arr = new IQueryable[plan.getInstallerPlan() == null ? 1 : 2];
        arr[0] = plan.getAdditions();
        if (plan.getInstallerPlan() != null) {
            arr[1] = plan.getInstallerPlan().getAdditions();
        }
        return new CompoundQueryable(arr);
    }

    private IQueryable<IInstallableUnit> slice(IProgressMonitor monitor) throws ProvisionException {
        if (this.slicingOptions == null) {
            this.slicingOptions = new SlicingOptions();
        }
        if (this.slicingOptions.getInstallTimeLikeResolution()) {
            return this.performResolution(monitor);
        }
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.getCompositeMetadataRepository(), this.slicingOptions.getFilter(), this.slicingOptions.includeOptionalDependencies(), this.slicingOptions.isEverythingGreedy(), this.slicingOptions.forceFilterTo(), this.slicingOptions.considerStrictDependencyOnly(), this.slicingOptions.followOnlyFilteredRequirements());
        IQueryable slice = slicer.slice(this.sourceIUs.toArray(new IInstallableUnit[this.sourceIUs.size()]), monitor);
        if (slice != null && this.slicingOptions.latestVersionOnly()) {
            IQueryResult queryResult = slice.query(QueryUtil.createLatestIUQuery(), monitor);
            slice = queryResult;
        }
        if (slicer.getStatus().getSeverity() != 0 && this.mirrorLog != null) {
            this.mirrorLog.log((IStatus)slicer.getStatus());
        }
        if (slice == null) {
            throw new ProvisionException((IStatus)slicer.getStatus());
        }
        return slice;
    }

    public void setSlicingOptions(SlicingOptions options) {
        this.slicingOptions = options;
    }

    public void setBaseline(URI baseline) {
        this.baseline = baseline;
        this.compare = true;
    }

    public void setComparatorID(String value) {
        this.comparatorID = value;
        this.compare = true;
    }

    public void setCompare(boolean value) {
        this.compare = value;
    }

    public void setIgnoreErrors(boolean value) {
        this.failOnError = !value;
    }

    public void setRaw(boolean value) {
        this.raw = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setComparatorLog(File comparatorLog) {
        this.comparatorLogFile = comparatorLog;
    }

    public void setLog(File mirrorLog) {
        this.mirrorLogFile = mirrorLog;
    }

    public void setLog(IArtifactMirrorLog log) {
        this.mirrorLog = log;
    }

    public void setValidate(boolean value) {
        this.validate = value;
    }

    public void setReferences(boolean flag) {
        this.mirrorReferences = flag;
    }

    public void setComparatorExclusions(IQuery<IArtifactDescriptor> exclusions) {
        this.compareExclusions = exclusions;
    }

    public void setIncludePacked(boolean includePacked) {
        this.includePacked = includePacked;
    }
}

