/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.macro.file;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Path {
    public static final char SEGMENT_SEPARATOR = '/';
    private static final Splitter splitter = Splitter.on((char)'/');
    public static final Path ROOT = new Path("/");
    private final ImmutableList<String> segments;
    private final boolean absolute;

    public Path(String pathAsString) {
        if (pathAsString == null) {
            throw new NullPointerException();
        }
        if (pathAsString.trim().length() == 0) {
            throw new IllegalArgumentException("empty path");
        }
        Iterable iterable = splitter.split((CharSequence)(pathAsString = pathAsString.replace('\\', '/')));
        this.absolute = ((String)iterable.iterator().next()).length() == 0;
        Iterable withoutEmptySegements = Iterables.filter((Iterable)iterable, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && input.trim().length() > 0;
            }
        });
        this.segments = ImmutableList.copyOf(this.normalize(withoutEmptySegements));
    }

    private Path(List<String> segments, boolean isAbsolute) {
        this.segments = ImmutableList.copyOf(this.normalize(segments));
        this.absolute = isAbsolute;
    }

    private Iterable<String> normalize(Iterable<String> segments2) {
        ArrayList result = Lists.newArrayList();
        boolean canRemoveSegment = false;
        for (String seg : segments2) {
            String string = seg.trim();
            if (canRemoveSegment && string.equals("..")) {
                result.remove(result.size() - 1);
                canRemoveSegment = !result.isEmpty() && !((String)result.get(0)).equals("..");
                continue;
            }
            if (string.equals(".")) continue;
            result.add(string);
            boolean bl = canRemoveSegment = !string.equals("..");
        }
        return result;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getLastSegment() {
        return this.segments.isEmpty() ? null : (String)this.segments.get(this.segments.size() - 1);
    }

    public Path append(String suffix) {
        return new Path(String.valueOf(this.toString()) + '/' + suffix);
    }

    public Path getParent() {
        if (!this.isAbsolute()) {
            throw new IllegalStateException("path is not absolute");
        }
        if (this.segments.isEmpty()) {
            return null;
        }
        return new Path((List<String>)this.segments.subList(0, this.segments.size() - 1), true);
    }

    public String getFileExtension() {
        String lastSegment = this.getLastSegment();
        int idx = lastSegment.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return lastSegment.substring(idx + 1);
    }

    public Path getAbsolutePath(String relativePath) {
        Path other = new Path(relativePath);
        return this.getAbsolutePath(other);
    }

    public Path getAbsolutePath(Path relativePath) {
        if (relativePath.isAbsolute()) {
            throw new IllegalArgumentException("The given path'" + relativePath + "' is not relative.");
        }
        ArrayList result = Lists.newArrayList(this.getSegments());
        for (String segment : relativePath.getSegments()) {
            if (segment.equals("..")) {
                result.remove(result.size() - 1);
                continue;
            }
            if (segment.equals(".")) continue;
            result.add(segment);
        }
        return new Path(result, true);
    }

    public Path relativize(String other) {
        return this.relativize(new Path(other));
    }

    public Path relativize(Path other) {
        if (other.isAbsolute() != this.isAbsolute()) {
            throw new IllegalArgumentException("This path and the given path are not both absolute or both relative.");
        }
        if (this.startsWith(other)) {
            return this.internalRelativize(this, other);
        }
        if (other.startsWith(this)) {
            return this.internalRelativize(other, this);
        }
        return null;
    }

    private Path internalRelativize(Path path, Path prefix) {
        return new Path(path.getSegments().subList(prefix.getSegments().size(), path.getSegments().size()), false);
    }

    public boolean startsWith(Path other) {
        int thisSegmentSize;
        if (this.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        List<String> otherSegments = other.getSegments();
        List<String> thisSegments = this.getSegments();
        int otherSegmentSize = otherSegments.size();
        if (otherSegmentSize > (thisSegmentSize = thisSegments.size())) {
            return false;
        }
        int i = 0;
        while (i < otherSegmentSize) {
            String thisSeg;
            String otherSeg = otherSegments.get(i);
            if (!otherSeg.equals(thisSeg = thisSegments.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolute ? 1231 : 1237);
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        if (this.absolute != other.absolute) {
            return false;
        }
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isAbsolute()) {
            result.append('/');
        }
        int size = this.segments.size();
        int i = 0;
        while (i < size) {
            String segment = (String)this.segments.get(i);
            result.append(segment);
            if (i < size - 1) {
                result.append('/');
            }
            ++i;
        }
        return result.toString();
    }
}

