/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Application;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.translation.TranslationProviderFactory;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.internal.workbench.PlaceholderResolver;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.SelectionAggregator;
import org.eclipse.e4.ui.internal.workbench.SelectionServiceImpl;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPlaceholderResolver;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.osgi.util.AbstractJFXApplication;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.internal.GraphicsLoaderImpl;
import org.eclipse.fx.ui.workbench.fx.internal.LoggerProviderImpl;
import org.eclipse.fx.ui.workbench.fx.internal.WorkbenchJFXActivator;
import org.eclipse.osgi.service.datalocation.Location;

public class E4Application
extends AbstractJFXApplication {
    public static final String THEME_ID = "cssTheme";
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "2";
    private static final String EXIT_CODE = "e4.osgi.exit.code";
    private static final String CONTEXT_INITIALIZED = "org.eclipse.ui.contextInitialized";
    private String[] args;
    private Object lcManager;
    private E4Workbench workbench = null;
    private IModelResourceHandler handler;
    private IEclipseContext workbenchContext;
    private Location instanceLocation;
    Logger logger = LoggerCreator.createLogger(((Object)((Object)this)).getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jfxStart(IApplicationContext applicationContext, Application jfxApplication, Stage primaryStage) {
        this.workbench = this.createE4Workbench(applicationContext, jfxApplication, primaryStage);
        if (this.workbench == null) return;
        this.instanceLocation = (Location)this.workbench.getContext().get("instanceLocation");
        try {
            if (!this.checkInstanceLocation(this.instanceLocation)) {
                return;
            }
            this.workbenchContext = this.workbench.getContext();
            this.workbench.createAndRunUI((MApplicationElement)this.workbench.getApplication());
            return;
        }
        finally {
            applicationContext.applicationRunning();
        }
    }

    protected Object jfxStop() {
        Object returnCode = null;
        try {
            if (this.workbenchContext != null && this.workbench != null) {
                returnCode = this.workbenchContext.get(EXIT_CODE);
                if (this.lcManager != null) {
                    ContextInjectionFactory.invoke((Object)this.lcManager, PreSave.class, (IEclipseContext)this.workbenchContext, null);
                }
                this.saveModel();
                this.workbench.close();
            }
        }
        finally {
            if (this.instanceLocation != null) {
                this.instanceLocation.release();
            }
        }
        if (returnCode != null) {
            return returnCode;
        }
        return super.jfxStop();
    }

    public E4Workbench createE4Workbench(IApplicationContext applicationContext, Application jfxApplication, Stage primaryStage) {
        this.args = (String[])applicationContext.getArguments().get("application.args");
        final IEclipseContext appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.setDefault((IEclipseContext)appContext);
        appContext.set(Application.class, (Object)jfxApplication);
        appContext.set("primaryStage", (Object)primaryStage);
        appContext.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                if (javafx.application.Platform.isFxApplicationThread()) {
                    runnable.run();
                } else {
                    FutureTask<Object> task = new FutureTask<Object>(runnable, null);
                    javafx.application.Platform.runLater(task);
                    try {
                        try {
                            task.get();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            task.cancel(true);
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            task.cancel(true);
                        }
                    }
                    finally {
                        task.cancel(true);
                    }
                }
            }

            public void asyncExec(Runnable runnable) {
                javafx.application.Platform.runLater((Runnable)runnable);
            }
        });
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        appContext.set(GraphicsLoader.class, (Object)((GraphicsLoader)ContextInjectionFactory.make(GraphicsLoaderImpl.class, (IEclipseContext)appContext)));
        appContext.set(IResourceUtilities.class, (Object)new IResourceUtilities<Image>(){

            public Image imageDescriptorFromURI(URI iconPath) {
                GraphicsLoader l = (GraphicsLoader)appContext.get(GraphicsLoader.class);
                return l.getImage(iconPath);
            }
        });
        if (!appContext.containsKey("org.eclipse.e4.ui.workbench.modeling.EModelService")) {
            throw new IllegalStateException("Core services not available. Please make sure that a declarative service implementation (such as the bundle 'org.eclipse.equinox.ds') is available!");
        }
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        String lifeCycleURI = this.getArgValue("lifeCycleURI", applicationContext, false);
        if (lifeCycleURI != null) {
            Boolean rv;
            this.lcManager = factory.create(lifeCycleURI, appContext);
            if (this.lcManager != null && (rv = (Boolean)ContextInjectionFactory.invoke((Object)this.lcManager, PostContextCreate.class, (IEclipseContext)appContext, (Object)Boolean.TRUE)) != null && !rv.booleanValue()) {
                return null;
            }
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        appContext.set(MApplication.class.getName(), (Object)appModel);
        E4Application.initializeServices(appModel);
        if (this.lcManager != null) {
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessAdditions.class, (IEclipseContext)appContext, null);
            ContextInjectionFactory.invoke((Object)this.lcManager, ProcessRemovals.class, (IEclipseContext)appContext, null);
        }
        IEclipseContext addonStaticContext = EclipseContextFactory.create();
        for (MAddon addon : appModel.getAddons()) {
            addonStaticContext.set(MAddon.class, (Object)addon);
            Object obj = factory.create(addon.getContributionURI(), appContext, addonStaticContext);
            addon.setObject(obj);
        }
        String xmiURI = this.getArgValue("applicationXMI", applicationContext, false);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = this.getArgValue(THEME_ID, applicationContext, false);
        appContext.set(THEME_ID, (Object)themeId);
        appContext.set("rendererFactoryUri", (Object)this.getArgValue("rendererFactoryUri", applicationContext, false));
        String presentationURI = this.getArgValue("presentationURI", applicationContext, false);
        if (presentationURI == null) {
            presentationURI = "bundleclass://org.eclipse.fx.ui.workbench.fx/org.eclipse.fx.ui.workbench.fx.PartRenderingEngine";
        }
        appContext.set("presentationURI", (Object)presentationURI);
        this.workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        return this.workbench;
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        Location instanceLocation = WorkbenchJFXActivator.getDefault().getInstanceLocation();
        String appModelPath = this.getArgValue("applicationXMI", appContext, false);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", (Object)instanceLocation);
        String value = this.getArgValue("persistState", appContext, false);
        boolean saveAndRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("persistState", (Object)saveAndRestore);
        value = this.getArgValue("clearPersistedState", appContext, true);
        boolean clearPersistedState = value != null && Boolean.parseBoolean(value);
        eclipseContext.set("clearPersistedState", (Object)clearPersistedState);
        value = this.getArgValue("deltaRestore", appContext, false);
        boolean deltaRestore = value == null || Boolean.parseBoolean(value);
        eclipseContext.set("deltaRestore", (Object)deltaRestore);
        String resourceHandler = this.getArgValue("modelResourceHandler", appContext, false);
        if (resourceHandler == null) {
            resourceHandler = "bundleclass://org.eclipse.e4.ui.workbench/" + ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        return theApp;
    }

    private String getArgValue(String argName, IApplicationContext appContext, boolean singledCmdArgValue) {
        int i;
        if (argName == null || argName.length() == 0) {
            return null;
        }
        if (singledCmdArgValue) {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i])) {
                    return "true";
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.args.length) {
                if (("-" + argName).equals(this.args[i]) && i + 1 < this.args.length) {
                    return this.args[i + 1];
                }
                ++i;
            }
        }
        String brandingProperty = appContext.getBrandingProperty(argName);
        return brandingProperty == null ? System.getProperty(argName) : brandingProperty;
    }

    public static IEclipseContext createDefaultHeadlessContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        serviceContext.set(IContributionFactory.class, (Object)contributionFactory);
        serviceContext.set(IExceptionHandler.class, (Object)exceptionHandler);
        serviceContext.set(IExtensionRegistry.class, (Object)registry);
        String locale = Locale.getDefault().toString();
        serviceContext.set("org.eclipse.e4.core.locale", (Object)locale);
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)serviceContext);
        serviceContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        serviceContext.set(Adapter.class, (Object)((Adapter)ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)serviceContext)));
        if (serviceContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(LoggerProviderImpl.class, (IEclipseContext)serviceContext)));
        }
        return serviceContext;
    }

    public static IEclipseContext createDefaultContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        if (appContext.get(ILoggerProvider.class) == null) {
            serviceContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(LoggerProviderImpl.class, (IEclipseContext)serviceContext)));
        }
        appContext.set(org.eclipse.e4.core.services.log.Logger.class.getName(), (Object)((ILoggerProvider)serviceContext.get(ILoggerProvider.class)).getClassLogger(E4Workbench.class));
        appContext.set(EModelService.class, (Object)new ModelServiceImpl(appContext));
        appContext.set(EPlaceholderResolver.class, (Object)new PlaceholderResolver());
        String locale = Locale.getDefault().toString();
        appContext.set("org.eclipse.e4.core.locale", (Object)locale);
        TranslationService bundleTranslationProvider = TranslationProviderFactory.bundleTranslationService((IEclipseContext)appContext);
        appContext.set(TranslationService.class, (Object)bundleTranslationProvider);
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        return appContext;
    }

    private boolean checkInstanceLocation(Location instanceLocation) {
        if (instanceLocation == null) {
            return false;
        }
        if (instanceLocation.isSet()) {
            block6: {
                if (!this.checkValidWorkspace(instanceLocation.getURL())) {
                    return false;
                }
                if (!instanceLocation.lock()) break block6;
                E4Application.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLocation.getURL().getFile());
                workspaceDirectory.exists();
            }
            catch (IOException e) {
                this.logger.error("Could not create instance location", (Throwable)e);
            }
            return false;
        }
        return false;
    }

    private boolean checkValidWorkspace(URL url) {
        if (url == null) {
            return false;
        }
        String version = E4Application.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        return true;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = E4Application.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(versionFile);){
                props.load(is);
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            LoggerCreator.createLogger(E4Application.class).error("Unable to create workspace", (Throwable)e);
            return null;
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = E4Application.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=2";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    LoggerCreator.createLogger(E4Application.class).error("Unable to write workspace version", (Throwable)e);
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initializeServices(MApplication appModel) {
        IEclipseContext appContext = appModel.getContext();
        if (appContext.containsKey(CONTEXT_INITIALIZED)) {
            return;
        }
        appContext.set(CONTEXT_INITIALIZED, (Object)"true");
        E4Application.initializeApplicationServices(appContext);
        List windows = appModel.getChildren();
        for (MWindow childWindow : windows) {
            E4Application.initializeWindowServices(childWindow);
        }
        ((EObject)appModel).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MApplication.class) != 15) {
                    return;
                }
                if (notification.getEventType() != 3) {
                    return;
                }
                MWindow childWindow = (MWindow)notification.getNewValue();
                E4Application.initializeWindowServices(childWindow);
            }
        });
    }

    public static void initializeApplicationServices(IEclipseContext appContext) {
        final IEclipseContext theContext = appContext;
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                IEclipseContext activeChildContext = context.getActiveChild();
                if (activeChildContext != null) {
                    Object selection = activeChildContext.get("org.eclipse.ui.selection");
                    theContext.set("org.eclipse.ui.selection", selection);
                }
                return true;
            }
        });
        appContext.set(ESelectionService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(SelectionServiceImpl.class, (IEclipseContext)context);
            }
        });
    }

    public static void initializeWindowServices(MWindow childWindow) {
        IEclipseContext windowContext = childWindow.getContext();
        E4Application.initWindowContext(windowContext);
        ((EObject)childWindow).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(MWindow.class) != 20) {
                    return;
                }
                IEclipseContext windowContext = (IEclipseContext)notification.getNewValue();
                E4Application.initWindowContext(windowContext);
            }
        });
    }

    private static void initWindowContext(IEclipseContext windowContext) {
        if (windowContext == null) {
            return;
        }
        SelectionAggregator selectionAggregator = (SelectionAggregator)ContextInjectionFactory.make(SelectionAggregator.class, (IEclipseContext)windowContext);
        windowContext.set(SelectionAggregator.class, (Object)selectionAggregator);
    }
}

