/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

class CellUtil2 {
    CellUtil2() {
    }

    static Cell<?> getRowNode(Cell<?> cell) {
        if (cell instanceof TableCell) {
            return ((TableCell)cell).getTableRow();
        }
        return cell;
    }

    static MultipleSelectionModel<?> getSelectionModel(Cell<?> cell) {
        if (cell instanceof ListCell) {
            return ((ListCell)cell).getListView().getSelectionModel();
        }
        if (cell instanceof TreeCell) {
            return ((TreeCell)cell).getTreeView().getSelectionModel();
        }
        if (cell instanceof TableCell) {
            return ((TableCell)cell).getTableView().getSelectionModel();
        }
        if (cell instanceof TableRow) {
            return ((TableRow)cell).getTableView().getSelectionModel();
        }
        throw new IllegalArgumentException("Unsupported Cell type");
    }

    static MultipleSelectionModel<?> getSelectionModel(Control view) {
        if (view instanceof TreeView) {
            return ((TreeView)view).getSelectionModel();
        }
        throw new IllegalArgumentException("Unsupported View type");
    }

    static List<?> getSelectedItems(Cell<?> cell) {
        MultipleSelectionModel<?> selectionModel = CellUtil2.getSelectionModel(cell);
        ObservableList items = selectionModel.getSelectedItems();
        if (cell instanceof TreeCell) {
            ArrayList<Object> unwrappedItems = new ArrayList<Object>(items.size());
            for (Object item : items) {
                unwrappedItems.add(((TreeItem)item).getValue());
            }
            return unwrappedItems;
        }
        return items;
    }
}

