/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;

public class Files {
    private static Logger log = Logger.getLogger(Files.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFiles(String sourceDir, String targetDir, List<String> files) {
        File target = new File(targetDir);
        if (!target.exists()) {
            target.mkdir();
        }
        for (String file : files) {
            File copy = new File(target.getAbsolutePath() + File.separatorChar + file);
            if (copy.exists()) continue;
            String uri = sourceDir + "/" + file;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream is = contextClassLoader.getResourceAsStream(uri);
            try {
                copy.createNewFile();
                try (FileOutputStream fwr = new FileOutputStream(copy);){
                    int read;
                    byte[] buff = new byte[1024];
                    while ((read = is.read(buff)) != -1) {
                        fwr.write(buff, 0, read);
                    }
                }
                log.debug((Object)("Copied " + copy));
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) throws FileNotFoundException {
        String[] children;
        if (!parentFolder.exists()) {
            throw new FileNotFoundException(parentFolder.getAbsolutePath());
        }
        FileFilter myFilter = filter;
        if (myFilter == null) {
            myFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        log.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(myFilter);
        if (contents == null) {
            return true;
        }
        for (int j = 0; j < contents.length; ++j) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (Files.cleanFolder(file, myFilter, continueOnError, true) || continueOnError) continue;
                return false;
            }
            if (file.delete()) continue;
            log.error((Object)("Couldn't delete " + file.getAbsolutePath()));
            if (continueOnError) continue;
            return false;
        }
        if (deleteParentFolder && (children = parentFolder.list()) != null && children.length == 0 && !parentFolder.delete()) {
            log.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public static boolean sweepFolder(File folder) throws FileNotFoundException {
        return Files.cleanFolder(folder, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        }, true, false);
    }

    @Deprecated
    public static String readFileIntoString(String filename) {
        try {
            FileInputStream inputStream = new FileInputStream(filename);
            return Files.readStreamIntoString(inputStream);
        }
        catch (FileNotFoundException e) {
            throw new WrappedException((Exception)e);
        }
    }

    @Deprecated
    public static byte[] readStreamIntoByteArray(InputStream inputStream) {
        try {
            return ByteStreams.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public static String readStreamIntoString(InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream");
        try {
            return new String(ByteStreams.toByteArray((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public static void writeStringIntoFile(String filename, String content) {
        try {
            File file = new File(filename);
            com.google.common.io.Files.write((byte[])content.getBytes(), (File)file);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }
}

