/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.Optional;

public abstract class Version
implements Comparable<Version> {
    private int hash;

    public abstract int getMajor();

    public abstract int getMinor();

    public abstract int getMicro();

    public abstract Optional<String> getQualifier();

    public final int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 527;
        h = 31 * h + this.getMajor();
        h = 31 * h + this.getMinor();
        h = 31 * h + this.getMicro();
        this.hash = h = 31 * h + this.getQualifier().hashCode();
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        return this.getMajor() == v.getMajor() && this.getMinor() == v.getMinor() && this.getMicro() == v.getMicro() && this.getQualifier().equals(v.getQualifier());
    }

    public static Version createVersion(int major, int minor, int micro) {
        return new VersionImpl(major, minor, micro, null);
    }

    public static Version createVersion(int major, int minor, int micro, String qualifier) {
        return new VersionImpl(major, minor, micro, qualifier);
    }

    public static Version createVersion(String versionString) {
        String[] parts = versionString.split("\\.");
        if (parts.length > 2) {
            String qualifier = null;
            if (parts[2].indexOf(95) != -1) {
                qualifier = parts[2].substring(parts[2].indexOf(95) + 1);
                parts[2] = parts[2].substring(0, parts[2].indexOf(95));
            }
            if (parts[2].indexOf(45) != -1) {
                qualifier = parts[2].substring(parts[2].indexOf(45) + 1);
                parts[2] = parts[2].substring(0, parts[2].indexOf(45));
            }
            return Version.createVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), qualifier);
        }
        throw new IllegalArgumentException("Invalid version string '" + versionString + "'");
    }

    static class VersionImpl
    extends Version {
        private final int major;
        private final int minor;
        private final int micro;
        private final Optional<String> qualifier;

        public VersionImpl(int major, int minor, int micro, String qualifier) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.qualifier = Optional.ofNullable(qualifier);
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public int getMicro() {
            return this.micro;
        }

        @Override
        public Optional<String> getQualifier() {
            return this.qualifier;
        }

        @Override
        public int compareTo(Version o) {
            int rv = Integer.compare(this.major, o.getMajor());
            if (rv != 0) {
                return rv;
            }
            rv = Integer.compare(this.minor, o.getMinor());
            if (rv != 0) {
                return rv;
            }
            rv = Integer.compare(this.micro, o.getMicro());
            if (rv != 0) {
                return rv;
            }
            return this.qualifier.orElse("").compareTo(o.getQualifier().orElse(""));
        }

        public String toString() {
            return "VersionImpl [major=" + this.major + ", minor=" + this.minor + ", micro=" + this.micro + ", qualifier=" + this.qualifier + "]";
        }
    }
}

