/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.common.terminal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.console.common.KEYS;

public abstract class TerminalTypeMappings {
    protected Map<String, KEYS> escapesToKey = new HashMap<String, KEYS>();
    protected String[] escapes;
    protected byte BACKSPACE;
    protected byte DEL;

    public TerminalTypeMappings() {
        this.escapesToKey.put("[A", KEYS.UP);
        this.escapesToKey.put("[B", KEYS.DOWN);
        this.escapesToKey.put("[C", KEYS.RIGHT);
        this.escapesToKey.put("[D", KEYS.LEFT);
        this.escapesToKey.put("[G", KEYS.CENTER);
        this.setKeypadMappings();
        this.createEscapes();
    }

    public Map<String, KEYS> getEscapesToKey() {
        return this.escapesToKey;
    }

    public String[] getEscapes() {
        if (this.escapes != null) {
            String[] copy = new String[this.escapes.length];
            System.arraycopy(this.escapes, 0, copy, 0, this.escapes.length);
            return copy;
        }
        return null;
    }

    public byte getBackspace() {
        return this.BACKSPACE;
    }

    public byte getDel() {
        return this.DEL;
    }

    public abstract void setKeypadMappings();

    private void createEscapes() {
        this.escapes = new String[this.escapesToKey.size()];
        Object[] temp = this.escapesToKey.keySet().toArray();
        int i = 0;
        while (i < this.escapes.length) {
            this.escapes[i] = (String)temp[i];
            ++i;
        }
    }
}

