/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.fx.core.IOUtils;
import org.eclipse.fx.core.URLDynamicDataStreamHandler;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;

@Component
public class TplURLDynamicDataStreamHandler
implements URLDynamicDataStreamHandler {
    private static final String ID = "tplUrlHandler";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public @Nullable InputStream createDataStream(URL url) {
        try {
            String data;
            URL realURL = new URL(url.getPath());
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream stream = realURL.openStream();){
                data = StrSubstitutor.replace((Object)IOUtils.readToString(stream, Charset.forName("UTF-8")), TplURLDynamicDataStreamHandler.map(url.getQuery()), (String)"_(", (String)")");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new ByteArrayInputStream(data.getBytes());
        }
        catch (IOException e) {
            LoggerCreator.createLogger(TplURLDynamicDataStreamHandler.class).error("Failed to load real data", (Throwable)e);
            return null;
        }
    }

    private static final Map<String, String> map(String query) {
        if (query != null) {
            return Stream.of(query.split("&")).map(e -> e.split("=")).collect(Collectors.toMap(e -> e[0], e -> e[1]));
        }
        return Collections.emptyMap();
    }
}

