/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.drift.DriftFXSurface;
import org.eclipse.fx.drift.Renderer;
import org.eclipse.fx.drift.Swapchain;
import org.eclipse.fx.drift.SwapchainConfig;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.backend.Backend;
import org.eclipse.fx.drift.internal.backend.BackendImpl;
import org.eclipse.fx.drift.internal.frontend.Frontend;
import org.eclipse.fx.drift.internal.frontend.FrontendImpl;
import org.eclipse.fx.drift.internal.transport.VMTransport;

public class RendererImpl
implements Renderer {
    private static final DriftLogger LOGGER = DriftFX.createLogger(RendererImpl.class);
    private static Map<DriftFXSurface, Renderer> renderers = new HashMap<DriftFXSurface, Renderer>();
    private DriftFXSurface surface;
    private Backend backend;
    private Frontend frontend;
    private VMTransport transport;

    public static Renderer getRenderer(DriftFXSurface surface) {
        return renderers.computeIfAbsent(surface, surf -> new RendererImpl((DriftFXSurface)((Object)surf)));
    }

    public RendererImpl(DriftFXSurface surface) {
        this.surface = surface;
        this.backend = new BackendImpl();
        this.frontend = new FrontendImpl(surface);
        this.transport = new VMTransport(this.frontend, this.backend);
        this.transport.start();
    }

    @Override
    public Vec2i getSize() {
        double w = this.surface.getWidth();
        double h = this.surface.getHeight();
        double userScale = this.surface.getUserScaleFactor();
        double screenScale = this.surface.getScreenScaleFactor();
        int x = (int)Math.ceil(w * userScale * screenScale);
        int y = (int)Math.ceil(h * userScale * screenScale);
        return new Vec2i(x, y);
    }

    @Override
    public Swapchain createSwapchain(SwapchainConfig config) {
        return this.backend.createSwapchain(config);
    }
}

