/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.fx.drift.SwapchainConfig;
import org.eclipse.fx.drift.internal.backend.Backend;
import org.eclipse.fx.drift.internal.backend.BackendSwapchain;
import org.eclipse.fx.drift.internal.backend.SimpleSwapchain;
import org.eclipse.fx.drift.internal.transport.Command;
import org.eclipse.fx.drift.internal.transport.command.CreateSwapchainCommand;
import org.eclipse.fx.drift.internal.transport.command.ReleaseCommand;
import org.eclipse.fx.drift.internal.transport.command.SwapchainCreatedCommand;

public class BackendImpl
implements Backend {
    private Map<UUID, BackendSwapchain> swapChains = new HashMap<UUID, BackendSwapchain>();
    private BackendSwapchain swapChain;
    private Consumer<Command> commandChannel;
    private Map<Predicate<Command>, CompletableFuture<?>> await = new HashMap();

    @Override
    public BackendSwapchain createSwapchain(SwapchainConfig config) {
        UUID id = UUID.randomUUID();
        this.swapChain = new SimpleSwapchain(this, id, config);
        this.swapChain.allocate();
        this.swapChains.put(id, this.swapChain);
        CompletableFuture<SwapchainCreatedCommand> waitForCreated = this.waitForCommand(SwapchainCreatedCommand.class, c -> id.equals(c.getId()));
        this.sendCommand(new CreateSwapchainCommand(id, this.swapChain.getImages(), config.presentationMode));
        waitForCreated.join();
        return this.swapChain;
    }

    @Override
    public void setCommandChannel(Consumer<Command> commandChannel) {
        this.commandChannel = commandChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Command> CompletableFuture<C> waitForCommand(Class<C> type, Predicate<C> filter) {
        CompletableFuture result = new CompletableFuture();
        Map<Predicate<Command>, CompletableFuture<?>> map = this.await;
        synchronized (map) {
            this.await.put(command -> type.isAssignableFrom(command.getClass()) && filter.test(command), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCommand(Command command) {
        Map<Predicate<Command>, CompletableFuture<?>> map = this.await;
        synchronized (map) {
            for (Predicate<Command> test : this.await.keySet()) {
                if (!test.test(command)) continue;
                CompletableFuture<?> f = this.await.remove(test);
                f.complete(command);
            }
        }
        if (command instanceof ReleaseCommand) {
            ReleaseCommand cmd = (ReleaseCommand)command;
            this.swapChains.get(cmd.getSwapChainId()).release(cmd.getImageData());
        }
    }

    @Override
    public void sendCommand(Command command) {
        this.commandChannel.accept(command);
    }
}

