/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.fx.drift.LoggingService;
import org.eclipse.fx.drift.internal.StdOutLoggingService;

public final class DriftFXConfig {
    private static final Map<String, ConfigValue<?>> CONFIG = new HashMap();
    private static final String KEY_LOG_LEVEL = "driftfx.loglevel";
    private static final String KEY_SHOW_FPS = "driftfx.showfps";
    private static final String KEY_USE_JAVA_LIBRARY_PATH = "driftfx.use.java.library.path";
    private static final String KEY_LOGGING_SERVICE = "driftfx.logging.service";

    private DriftFXConfig() {
    }

    private static LoggingService convert(String name) {
        try {
            return (LoggingService)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return new StdOutLoggingService();
        }
    }

    private static <T> void register(ConfigValue<T> value) {
        CONFIG.put(((ConfigValue)value).key, value);
    }

    private static <T> ConfigValue<T> get(String key) {
        return CONFIG.get(key);
    }

    public static int getLogLevel() {
        return (Integer)DriftFXConfig.get(KEY_LOG_LEVEL).getValue();
    }

    public static void setLogLevel(int logLevel) {
        DriftFXConfig.get(KEY_LOG_LEVEL).setValue(logLevel);
    }

    public static boolean isShowFps() {
        return (Boolean)DriftFXConfig.get(KEY_SHOW_FPS).getValue();
    }

    public static void setShowFps(boolean showFps) {
        DriftFXConfig.get(KEY_SHOW_FPS).setValue(showFps);
    }

    public static boolean isUseJavaLibraryPath() {
        return (Boolean)DriftFXConfig.get(KEY_USE_JAVA_LIBRARY_PATH).getValue();
    }

    public static void setUseJavaLibraryPath(boolean useJavaLibraryPath) {
        DriftFXConfig.get(KEY_USE_JAVA_LIBRARY_PATH).setValue(useJavaLibraryPath);
    }

    public static LoggingService getLoggingService() {
        return (LoggingService)DriftFXConfig.get(KEY_LOGGING_SERVICE).getValue();
    }

    public static void setLoggingService(LoggingService service) {
        DriftFXConfig.get(KEY_LOGGING_SERVICE).setValue(service);
    }

    static {
        DriftFXConfig.register(new ConfigValue<Integer>(KEY_LOG_LEVEL, 0, Integer::parseInt));
        DriftFXConfig.register(new ConfigValue<Boolean>(KEY_SHOW_FPS, false, Boolean::parseBoolean));
        DriftFXConfig.register(new ConfigValue<Boolean>(KEY_USE_JAVA_LIBRARY_PATH, false, Boolean::parseBoolean));
        DriftFXConfig.register(new ConfigValue<LoggingService>(KEY_LOGGING_SERVICE, new StdOutLoggingService(), DriftFXConfig::convert));
    }

    private static class ConfigValue<T> {
        private final String key;
        private final Function<String, T> converter;
        private final T defaultValue;
        private T value;

        public ConfigValue(String key, T defaultValue, Function<String, T> converter) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.converter = converter;
            this.initialize();
        }

        public final void initialize() {
            String propValue = System.getProperty(this.key);
            T converted = ConfigValue.convertValue(propValue, this.converter);
            this.value = converted != null ? converted : this.defaultValue;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        private static <T> T convertValue(String value, Function<String, T> converter) {
            if (value == null) {
                return null;
            }
            try {
                T converted = converter.apply(value);
                return converted;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

