/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeRouting implements Enumerator
{
    STRAIGHT_LITERAL(0, "straight", "straight"),
    MANHATTAN_LITERAL(1, "manhattan", "manhattan"),
    TREE_LITERAL(2, "tree", "tree");

    public static final int STRAIGHT = 0;
    public static final int MANHATTAN = 1;
    public static final int TREE = 2;
    private static final EdgeRouting[] VALUES_ARRAY;
    public static final List<EdgeRouting> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeRouting[]{STRAIGHT_LITERAL, MANHATTAN_LITERAL, TREE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeRouting get(String literal) {
        EdgeRouting[] edgeRoutingArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeRouting result = edgeRoutingArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static EdgeRouting getByName(String name) {
        EdgeRouting[] edgeRoutingArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeRouting result = edgeRoutingArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static EdgeRouting get(int value) {
        switch (value) {
            case 0: {
                return STRAIGHT_LITERAL;
            }
            case 1: {
                return MANHATTAN_LITERAL;
            }
            case 2: {
                return TREE_LITERAL;
            }
        }
        return null;
    }

    private EdgeRouting(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

