/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import com.google.common.base.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.workspace.ISourceFolder;

public class EclipseSourceFolder
implements ISourceFolder {
    private final IProject project;
    private final String name;

    public EclipseSourceFolder(IProject project, String name) {
        this.project = project;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public URI getPath() {
        URI result = URI.createPlatformResourceURI((String)("/" + this.project.getName() + "/" + this.name), (boolean)true);
        if (result.hasTrailingPathSeparator()) {
            return result;
        }
        return result.appendSegment("");
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EclipseSourceFolder) {
            URI path1 = this.getPath();
            URI path2 = ((EclipseSourceFolder)obj).getPath();
            return Objects.equal((Object)path1, (Object)path2);
        }
        return false;
    }

    public String toString() {
        return "project " + this.project + " name " + this.name + " (" + this.getPath() + ")";
    }

    public IProject getProject() {
        return this.project;
    }
}

