/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaProvider;
import org.osgi.framework.BundleException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaToHTMLConverter {
    private final SchemaTransformer fTransformer = new SchemaTransformer();
    private File baseDir;
    private URL cssURL;

    public SchemaToHTMLConverter(File baseDir, URL cssURL) {
        this.baseDir = baseDir;
        this.cssURL = cssURL;
    }

    public void generate(String manifest, String destination, SchemaProvider schemaProvider, Consumer<String> errorConsumer) throws IOException, CoreException {
        IPluginExtensionPoint[] extPoints;
        Objects.requireNonNull(manifest, "manifest can't be null");
        Objects.requireNonNull(destination, "destination can't be null");
        IPluginModelBase model = this.readManifestFile(manifest);
        if (model == null) {
            return;
        }
        String pluginID = model.getPluginBase().getId();
        if (pluginID == null) {
            pluginID = this.getPluginID(manifest);
        }
        IPluginExtensionPoint[] iPluginExtensionPointArray = extPoints = model.getPluginBase().getExtensionPoints();
        int n = extPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extPoint = iPluginExtensionPointArray[n2];
            String schemaLocation = extPoint.getSchema();
            if (schemaLocation != null && !schemaLocation.equals("")) {
                Schema schema = null;
                try {
                    File directory;
                    File schemaFile = new File(model.getInstallLocation(), schemaLocation);
                    XMLDefaultHandler handler = new XMLDefaultHandler();
                    try {
                        XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE().parse(schemaFile, (DefaultHandler)handler);
                    }
                    catch (ParserConfigurationException | SAXException e) {
                        throw new IOException("XML Parser error", e);
                    }
                    URL url = schemaFile.toURL();
                    SchemaDescriptor desc = new SchemaDescriptor(extPoint.getFullId(), url, schemaProvider);
                    schema = (Schema)desc.getSchema(false);
                    ISchemaInclude[] includes = schema.getIncludes();
                    Object object = includes;
                    int n3 = includes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISchemaInclude include = object[n4];
                        if (include.getIncludedSchema() == null) {
                            errorConsumer.accept(NLS.bind((String)PDECoreMessages.ConvertSchemaToHTML_CannotFindIncludedSchema, (Object)include.getLocation(), (Object)schemaFile));
                        }
                        ++n4;
                    }
                    File file = directory = IPath.fromOSString((String)destination).isAbsolute() ? new File(destination) : new File(this.baseDir, destination);
                    if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                        schema.dispose();
                        return;
                    }
                    Object id = extPoint.getId();
                    if (((String)id).indexOf(46) == -1) {
                        id = pluginID + "." + (String)id;
                    }
                    File file2 = new File(directory, ((String)id).replace('.', '_') + ".html");
                    object = null;
                    Object var23_27 = null;
                    try (PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8), true);){
                        this.fTransformer.transform(schema, out, this.cssURL, (byte)1);
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                finally {
                    if (schema != null) {
                        schema.dispose();
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPluginID(String manifest) throws IOException {
        File file = IPath.fromOSString((String)manifest).isAbsolute() ? new File(manifest) : new File(this.baseDir, manifest);
        File OSGiFile = new File(file.getParentFile(), "META-INF/MANIFEST.MF");
        if (!OSGiFile.exists()) return null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream manifestStream = new FileInputStream(OSGiFile);){
                Map headers = ManifestElement.parseBundleManifest((InputStream)manifestStream, new ConcurrentSkipListMap(String::compareToIgnoreCase));
                String value = (String)headers.get("Bundle-SymbolicName");
                if (value == null) {
                    return null;
                }
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length <= 0) return null;
                return elements[0].getValue();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (BundleException bundleException) {
            throw new IOException("Invalid Manifest " + String.valueOf(OSGiFile), bundleException);
        }
    }

    protected IPluginModelBase readManifestFile(String manifest) throws IOException, CoreException {
        File file = IPath.fromOSString((String)manifest).isAbsolute() ? new File(manifest) : new File(this.baseDir, manifest);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            ExternalPluginModelBase model = null;
            switch (file.getName().toLowerCase(Locale.ENGLISH)) {
                case "fragment.xml": {
                    model = new ExternalFragmentModel();
                    break;
                }
                case "plugin.xml": {
                    model = new ExternalPluginModel();
                    break;
                }
                default: {
                    ((InputStream)stream).close();
                    throw new IOException(NLS.bind((String)PDECoreMessages.Builders_Convert_illegalValue, (Object)"manifest"));
                }
            }
            String parentPath = file.getParentFile().getAbsolutePath();
            model.setInstallLocation(parentPath);
            model.load(stream, false);
            ((InputStream)stream).close();
            return model;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

