/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.ExportDialog;
import org.eclipse.pde.api.tools.ui.internal.views.APIToolingView;

public class ExportSessionAction
extends Action {
    private static final String DELTAS_XSLT_TRANSFORM_PATH = "/compare.xsl";
    private static final String XML_FILE_EXTENSION = ".xml";
    private static final String HTML_FILE_EXTENSION = ".html";
    APIToolingView view;

    public ExportSessionAction(APIToolingView view) {
        this.setText(ActionMessages.ExportSessionAction_label);
        this.setToolTipText(ActionMessages.ExportSessionAction_tooltip);
        ImageDescriptor enabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_ELCL_EXPORT");
        this.setImageDescriptor(enabledImageDescriptor);
        ImageDescriptor disabledImageDescriptor = ApiUIPlugin.getImageDescriptor("IMG_DLCL_EXPORT");
        this.setDisabledImageDescriptor(disabledImageDescriptor);
        this.setEnabled(false);
        this.view = view;
    }

    public void run() {
        final ISession activeSession = ApiPlugin.getDefault().getSessionManager().getActiveSession();
        if (activeSession == null) {
            return;
        }
        ExportDialog dialog = new ExportDialog(this.view.getSite().getShell(), ActionMessages.ExportActionTitle);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        final String reportFileName = dialog.getValue();
        if (reportFileName == null) {
            return;
        }
        final String lowerCase = reportFileName.toLowerCase();
        if (!lowerCase.endsWith(HTML_FILE_EXTENSION) && !lowerCase.endsWith(XML_FILE_EXTENSION)) {
            return;
        }
        Job job = new Job(ActionMessages.CompareWithAction_comparing_apis){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                progress.subTask(ActionMessages.CompareDialogCollectingElementTaskName);
                boolean isHtmlFile = lowerCase.endsWith(ExportSessionAction.HTML_FILE_EXTENSION);
                File xmlOutputFile = null;
                progress.subTask(ActionMessages.CompareDialogComputeDeltasTaskName);
                File reportFile = new File(reportFileName);
                try {
                    progress.split(25);
                    try {
                        Serializable parent;
                        xmlOutputFile = isHtmlFile ? Util.createTempFile((String)String.valueOf(System.currentTimeMillis()), (String)ExportSessionAction.XML_FILE_EXTENSION) : reportFile;
                        if (xmlOutputFile.exists()) {
                            xmlOutputFile.delete();
                        } else {
                            parent = xmlOutputFile.getParentFile();
                            if (!((File)parent).exists() && !((File)parent).mkdirs()) {
                                return Status.error((String)ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                            }
                        }
                        parent = null;
                        Object var7_10 = null;
                        try (BufferedWriter writer = new BufferedWriter(new FileWriter(xmlOutputFile));){
                            DeltaXmlVisitor visitor = new DeltaXmlVisitor();
                            Object data = activeSession.getModel().getRoot().getData();
                            if (data instanceof IDelta) {
                                IDelta delta = (IDelta)data;
                                progress.split(25);
                                delta.accept((DeltaVisitor)visitor);
                                writer.write(visitor.getXML());
                                writer.flush();
                                progress.worked(25);
                            }
                        }
                        catch (Throwable throwable) {
                            if (parent == null) {
                                parent = throwable;
                            } else if (parent != throwable) {
                                ((Throwable)parent).addSuppressed(throwable);
                            }
                            throw parent;
                        }
                    }
                    catch (IOException | CoreException e) {
                        ApiPlugin.log((Throwable)e);
                    }
                    if (isHtmlFile) {
                        progress.split(10);
                        StreamSource xmlSource = new StreamSource(xmlOutputFile);
                        InputStream stream = ApiPlugin.class.getResourceAsStream(ExportSessionAction.DELTAS_XSLT_TRANSFORM_PATH);
                        StreamSource xsltSource = new StreamSource(stream);
                        try {
                            Serializable parent;
                            if (reportFile.exists()) {
                                reportFile.delete();
                            } else {
                                parent = reportFile.getParentFile();
                                if (!((File)parent).exists() && !((File)parent).mkdirs()) {
                                    return Status.error((String)ActionMessages.ExportSessionAction_failed_to_create_parent_folders);
                                }
                            }
                            parent = null;
                            Object var10_16 = null;
                            try (BufferedWriter writer = new BufferedWriter(new FileWriter(reportFile));){
                                StreamResult result = new StreamResult(writer);
                                TransformerFactory f = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
                                Transformer trans = f.newTransformer(xsltSource);
                                trans.transform(xmlSource, result);
                            }
                            catch (Throwable throwable) {
                                if (parent == null) {
                                    parent = throwable;
                                } else if (parent != throwable) {
                                    ((Throwable)parent).addSuppressed(throwable);
                                }
                                throw parent;
                            }
                        }
                        catch (IOException | TransformerException e) {
                            ApiUIPlugin.log(e);
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (OperationCanceledException e) {
                    if (xmlOutputFile != null && xmlOutputFile.exists()) {
                        xmlOutputFile.delete();
                    }
                    if (reportFile.exists()) {
                        reportFile.delete();
                    }
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setSystem(false);
        job.setPriority(30);
        job.schedule();
    }

    public void dispose() {
    }
}

